/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.ClassFileTransformer;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.IllegalClassFormatException;
import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import com.wily.rave.agent.ds.classmonitor.ClassTransformer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.security.ProtectionDomain;

public class ClassTransformerWrapper
implements ClassFileTransformer {
    private ClassTransformer transformer;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;

    public ClassTransformerWrapper(IAgent agent) throws ClassFileTransformerShouldNotRunException {
        this.fFeedback = RaveAgent.getCDFeedbackChannel(agent);
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.transformer = ClassTransformer.getTransformer();
    }

    public void disable() {
        try {
            this.transformer.disable();
        }
        catch (InterruptedException interruptedException) {
            this.fFeedback.debug("Interrupted whilst clearing classes list");
        }
    }

    public byte[] transform(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            return this.transformer.transform(classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        catch (InterruptedException interruptedException) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Rave_Agent_Failed_To_Save_Class", className));
            return classfileBuffer;
        }
    }

    public final ClassInfoContainer getNextClass(boolean keep) {
        try {
            return this.transformer.getNextClass(keep);
        }
        catch (InterruptedException interruptedException) {
            this.fFeedback.debug("Interrupted whilst retrieving class from list");
            return null;
        }
    }
}

