/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.IUpdatingDataSourceConfig;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.config.parser.PropertyParser;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.classmonitor.ClassMonitorDataSourceProps;
import com.wily.rave.agent.ds.classmonitor.RuntimeClassMonitor;
import com.wily.rave.agent.task.Schedule;
import com.wily.util.ExcludePattern;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RuntimeClassMonitorConfig
implements IUpdatingDataSourceConfig {
    private static final String UNIT = "unit";
    private static final String PROP_MAX_CLASS_SIZE_TO_UPLOAD = "maxClassSizeToUpload";
    private static final String PROP_POLLING_PERIOD = "delayBetweenIterations";
    private static final String PROP_CLASSES_PER_PERIOD = "classesPerIteration";
    private RuntimeClassMonitor fDataSource;
    protected List fExcludePatterns = new LinkedList();
    private ClassMonitorDataSourceProps configProps;
    private int pollingPeriodInSec = 2;
    protected static boolean dataSourceCreated = false;
    protected Element updatedXMLElement;

    @Override
    public IPolledDataSource parseConfig(Element dataSourceRoot, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws ConfigException {
        if (dataSourceCreated) {
            throw new ConfigException("Multiple data source instances of class monitor are not currently supported!");
        }
        dataSourceCreated = true;
        this.configProps = new ClassMonitorDataSourceProps();
        this.doParse(dataSourceRoot, feedback);
        try {
            this.fDataSource = new RuntimeClassMonitor(agent, this.fExcludePatterns.toArray(new ExcludePattern[this.fExcludePatterns.size()]), this.configProps);
        }
        catch (ClassFileTransformerShouldNotRunException e) {
            throw new ConfigException("Failed to create class monitor: " + e.getMessage());
        }
        return this.fDataSource;
    }

    public static boolean classMonitoringEnabled() {
        return dataSourceCreated;
    }

    @Override
    public Schedule getMainTaskSchedule() {
        return Schedule.getRepetetiveSchedule(this.pollingPeriodInSec);
    }

    protected void doParse(Element dataSourceRoot, IModuleFeedbackChannel feedback) throws ConfigException {
        Element clonedElement;
        this.updatedXMLElement = null;
        String version = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "version");
        if (version == null) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (version.equals("7.1")) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (!version.equals("8.0")) {
            throw new ConfigException("Unknown Class Monitor DataSource Config Version: " + version);
        }
        Node child = dataSourceRoot.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                this.parseChild(feedback, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseChild(IModuleFeedbackChannel feedback, Element child) throws ConfigException {
        String name = child.getNodeName();
        if (name.equals("exclude")) {
            String exclude = ElementParserHelper.getRequiredAttribute(child, "pattern", false);
            ExcludePattern excludePattern = new ExcludePattern(exclude);
            this.fExcludePatterns.add(excludePattern);
            Node includeChild = child.getFirstChild();
            while (includeChild != null) {
                if (includeChild instanceof Element) {
                    if (!includeChild.getNodeName().equals("include")) {
                        throw new ConfigException("Unexpected or invalid node: " + includeChild.getNodeName());
                    }
                    String include = ElementParserHelper.getRequiredAttribute((Element)includeChild, "pattern");
                    excludePattern.addIncludePattern(include);
                } else {
                    feedback.debug("Ignoring non element node " + includeChild.getNodeName() + " / " + includeChild.getNodeType() + " / \"" + includeChild.getNodeValue() + "\"");
                }
                includeChild = includeChild.getNextSibling();
            }
            return;
        } else {
            if (!name.equals("property")) throw new ConfigException("Unexpected or invalid node: " + name);
            PropertyParser propParser = new PropertyParser(child);
            String propName = propParser.getName();
            if (PROP_MAX_CLASS_SIZE_TO_UPLOAD.equals(propName)) {
                long maxFileSizeToUpload = propParser.getIntValue() * propParser.getDataSizeUnitMultilplier(UNIT, 1);
                if (maxFileSizeToUpload > 0L) {
                    this.configProps.maxFileSizeToUpload = maxFileSizeToUpload;
                    return;
                } else {
                    feedback.warn("Invalid value has been set for maxClassSizeToUpload. Using the default value of " + this.configProps.maxFileSizeToUpload);
                }
                return;
            } else if (PROP_POLLING_PERIOD.equals(propName)) {
                int pollingPeriod = propParser.getIntValue() * propParser.getTimeUnitMultiplier(UNIT, 1);
                if (pollingPeriod > 0) {
                    this.pollingPeriodInSec = pollingPeriod;
                    return;
                } else {
                    feedback.warn("Invalid value has been set for delayBetweenIterations. Using the default value of " + this.pollingPeriodInSec);
                }
                return;
            } else {
                if (!PROP_CLASSES_PER_PERIOD.equals(propName)) throw new ConfigException("Invalid property " + propParser);
                long maxClassesPerRun = propParser.getIntValue();
                if (maxClassesPerRun > 0L) {
                    this.configProps.maxClassesPerRun = maxClassesPerRun;
                    return;
                } else {
                    feedback.warn("Invalid value has been set for classesPerIteration. Using the default value of " + this.configProps.maxClassesPerRun);
                }
            }
        }
    }

    @Override
    public String getDataSourceType() {
        return "RuntimeClassMonitor";
    }

    @Override
    public boolean supportsEventDeletion() {
        return false;
    }

    @Override
    public Element getUpdatedXMLElement() {
        return this.updatedXMLElement;
    }

    @Override
    public boolean shouldExistingElementBeBackedUp() {
        return true;
    }

    @Override
    public boolean supportsEventBatching() {
        return false;
    }
}

