/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.CorrelationTracer;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;

public class JMSServerCorrelationTracer
extends CorrelationTracer {
    public JMSServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!TibcoBWUtils.correlationJMSReadEnabled()) {
            return;
        }
        boolean debug = this.fLogger.isDebugEnabled();
        try {
            Object currentMessageObject = data.getInvocationParameterAsObject(1);
            String CorIDAsString = (String)TibcoReflectionCache.getM_getObjectProperty(currentMessageObject, new Class[]{String.class}, new Object[]{"CorID"});
            if (CorIDAsString == null || CorIDAsString.equals("")) {
                CorIDAsString = (String)TibcoReflectionCache.getM_getObjectProperty(currentMessageObject, new Class[]{String.class}, new Object[]{"CorIDForSOAPInvocation"});
            }
            if (CorIDAsString == null || CorIDAsString.equals("")) {
                if (debug) {
                    this.fLogger.debug("JMSServerCorrelationTracer ITracer_startTrace no correlation id in JMS Message");
                }
                new CorrelationId();
            } else {
                String prevCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                new CorrelationId(CorIDAsString, true);
                SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
                if (debug) {
                    this.fLogger.debug("JMSServerCorrelationTracer NBThreadTxn = " + cache.getStringParamIn("NBThreadTxn"));
                }
                if (TibcoBWUtils.isMBBSEnabled()) {
                    String newCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
                    blameStackFeature.updateCorrelationInfo(prevCorID, newCorID);
                }
            }
        }
        catch (Throwable t) {
            this.fLogger.error("JMSServerCorrelationTracer ITracer_startTrace exception " + TibcoBWUtils.dumpStackTrace(t));
        }
    }
}

