/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.CorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class ProcessCorrelationTracer
extends CorrelationTracer {
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();
    private SharedCrossProcessData cache = null;
    private String fTransactionIdentity;
    private static final String[] excludeComponents = new String[]{"WebServices|Client", "Backends|"};

    public ProcessCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int traceIndex, InvocationData data) {
        Object ctxObj;
        HashMap<String, Object> ctxMap;
        Object processContext = data.getInvocationParameterAsObject(0);
        Object correlationData = new Object();
        this.cache = this.getComponentTracer().getCrossProcessDataCache();
        String transactionId = this.cache.getStringParamOut("TxnTraceId");
        if (transactionId == null) {
            this.fTransactionIdentity = sGuidGenerator.generateKey();
            this.cache.addParamOut("TxnTraceId", this.fTransactionIdentity);
        }
        if ((ctxMap = (ctxObj = data.get("Context_M")) == null ? this.getProcessContextMap(processContext) : (HashMap<String, Object>)ctxObj) == null) {
            ctxMap = new HashMap<String, Object>();
        }
        new CorrelationId();
        SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
        cache.markNextCrossProcessCallAsNonBlocking();
        if (correlationData != null) {
            if (TibcoBWUtils.isSerializationEnabled()) {
                correlationData = cache.getOutgoingSerializableInstance();
                this.fLogger.debug("Cross Process data serialization is enabled, if checkpoints are failing change the property value to false");
            } else {
                correlationData = new ThreadCorrelationId().getOutgoingStringFromInstance();
            }
            ctxMap.put("CorID", correlationData);
        }
        this.setProcessContextMap(processContext, ctxMap);
        data.put("Context_M", ctxMap);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getF_Job_M(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.error("Exception in getProcessContextMap :" + e.toString());
        }
        return ctxMap;
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getF_Job_M(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.error("Exception in setProcessContextMap :" + e.toString());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        block9: {
            Object processContext = data.getInvocationParameterAsObject(0);
            boolean isDebugEnabled = this.fLogger.isDebugEnabled();
            try {
                Object correlationData = new Object();
                Object ctxObj = data.get("Context_M");
                HashMap ctxMap = ctxObj == null ? this.getProcessContextMap(processContext) : (HashMap)ctxObj;
                if (ctxMap == null) {
                    ctxMap = new HashMap();
                }
                if (!ctxMap.containsKey("CorID")) break block9;
                SharedCrossProcessData cache = ComponentTracer.staticGetCrossProcessDataCache();
                if (TibcoBWUtils.isSerializationEnabled()) {
                    correlationData = (SharedCrossProcessData.SerializableSharedCrossProcessData)ctxMap.get("CorID");
                    cache.syncCache((SharedCrossProcessData.SerializableSharedCrossProcessData)correlationData);
                } else {
                    correlationData = (String)ctxMap.get("CorID");
                    new ThreadCorrelationId((String)correlationData);
                }
                if (isDebugEnabled) {
                    this.fLogger.debug("ProcessCorrelationTracer Correlation ID :" + correlationData);
                }
                new CorrelationId();
                if (isDebugEnabled) {
                    this.fLogger.debug("ProcessCorrelationTracer NBThreadTxn = " + cache.getStringParamIn("NBThreadTxn"));
                }
                if (!ComponentTracer.staticGetCrossProcessDataCache().getIncomingCalledByNodeId().contains(excludeComponents[0])) {
                    this.getComponentTracer();
                    if (!ComponentTracer.staticGetCrossProcessDataCache().getIncomingCalledByNodeId().contains(excludeComponents[1])) break block9;
                }
                this.getComponentTracer();
                ComponentTracer.staticGetCrossProcessDataCache().setIncomingCalledByNodeId("");
            }
            catch (Throwable exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

