/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatter;

public class WebServicesServerFormatter
extends BWGenericFormatter {
    public static final String C_SoapServiceConfig = "SoapServiceConfig";

    public WebServicesServerFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object m_config;
            Object headerSoaplet;
            Object invObj = data.getInvocationObject();
            if (invObj != null && (headerSoaplet = TibcoReflectionCache.getF_DefaultSoapApplication_headerSoaplet(invObj)) != null && (m_config = TibcoReflectionCache.getF_XDataAdapterSoaplet_ISoapServiceConfig(headerSoaplet)) != null) {
                if (m_config.getClass().getSimpleName().equalsIgnoreCase(C_SoapServiceConfig)) {
                    namespace = (String)TibcoReflectionCache.getM_SoapServiceConfig_getConcreteWsdlNamespace(m_config);
                } else {
                    Object endpointName = TibcoReflectionCache.getF_SoapServiceConfigAdapter_endpointName(m_config);
                    if (endpointName != null) {
                        namespace = (String)TibcoReflectionCache.getM_ExpandedName_getNamespaceURI(endpointName);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getNamespace: " + namespace);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object tUri;
            Object tCtx;
            Object soapMessage = data.getInvocationParameterAsObject(1);
            if (soapMessage != null && (tCtx = TibcoReflectionCache.getM_SoapMessage_getTransportContext(soapMessage)) != null && (tUri = TibcoReflectionCache.getM_TransportContext_getTransportUri(tCtx)) != null) {
                webServiceURI = tUri.toString();
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object xDataAdapSoaplet;
            Object dSoapApplication = data.getInvocationObject();
            if (dSoapApplication != null && (xDataAdapSoaplet = TibcoReflectionCache.getF_DefaultSoapApplication_bodySoaplet(dSoapApplication)) != null) {
                operationName = (String)TibcoReflectionCache.getF_XDataAdapterSoaplet_operationName(xDataAdapSoaplet);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getOperationName: " + operationName);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }
}

