/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.acc.agent;

import com.wily.introscope.acc.agent.RegisterAgentWithController;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.Map;

public class AccService
implements IAgentService {
    public static final String kACCMonitorEnabledKey = "introscope.agent.acc.enable";
    public static final String kACCMonitorPortKey = "introscope.agent.acc.port";
    public static final String kACCMonitorHeartBeat = "introscope.agent.acc.heartbeat";
    public static final String kACCMonitorInternalPoll = "introscope.agent.acc.poll";
    public static final int kDefaultPort = 51914;
    public static final int kDefaultPollInterval = 300000;
    public static final int kDefaultHeartBeat = 1440;
    private static final Module kACCMonitorServiceModule = new Module("AccAgentService");
    private IAgent fAgent;
    private static volatile ACCMonitorEnabledConfigurationProperty fACCMonitorEnabledConfigurationProperty;
    private static volatile ACCMonitorPortKeyProperty fACCMonitorPortKeyProperty;
    private static volatile ACCMonitorHeartBeatProperty fACCMonitorHeartBeatProperty;
    private static volatile ACCMonitorInternalPollProperty fACCMonitorInternalPollProperty;
    private RegisterAgentWithController fAgentController;
    private IRegisteredBehavior fBehavior;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map map) {
        this.fAgent = agent;
        fACCMonitorEnabledConfigurationProperty = new ACCMonitorEnabledConfigurationProperty(agent);
        fACCMonitorPortKeyProperty = new ACCMonitorPortKeyProperty(agent);
        fACCMonitorHeartBeatProperty = new ACCMonitorHeartBeatProperty(agent);
        fACCMonitorInternalPollProperty = new ACCMonitorInternalPollProperty(agent);
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        if (cm != null) {
            cm.add((ConfigurationProperty)fACCMonitorEnabledConfigurationProperty, true);
            cm.add((ConfigurationProperty)fACCMonitorPortKeyProperty, true);
            cm.add((ConfigurationProperty)fACCMonitorHeartBeatProperty, true);
            cm.add((ConfigurationProperty)fACCMonitorInternalPollProperty, true);
        } else {
            this.fAgent.IAgent_getModuleFeedback().warn(kACCMonitorServiceModule, "Agent Controller Registation properties could not be initialized because the configuration manager was not found");
        }
    }

    protected void setACCMonitorPortKeyProperty(ACCMonitorPortKeyProperty x) {
        fACCMonitorPortKeyProperty = x;
    }

    protected void setAgent(IAgent agent) {
        this.fAgent = agent;
    }

    protected void setACCMonitorHeartBeatProperty(ACCMonitorHeartBeatProperty x) {
        fACCMonitorHeartBeatProperty = x;
    }

    protected void setAgentController(RegisterAgentWithController x) {
        this.fAgentController = x;
    }

    protected void setACCMonitorInternalPollProperty(ACCMonitorInternalPollProperty x) {
        fACCMonitorInternalPollProperty = x;
    }

    protected synchronized IRegisteredBehavior getBehaviour() {
        return this.fBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stopRegistrationPoller() {
        if (this.fAgentController != null) {
            this.fAgentController.close();
            AccService accService = this;
            synchronized (accService) {
                if (this.fBehavior != null) {
                    this.fBehavior.close();
                    this.fAgent.IAgent_getModuleFeedback().info(kACCMonitorServiceModule, "Turned off agent controller registration");
                    this.fAgentController = null;
                    this.fBehavior = null;
                }
            }
            this.fAgentController = null;
        }
    }

    protected synchronized void scheduleNow() {
        if (this.fBehavior != null) {
            this.fBehavior.close();
            this.fBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.fAgentController, "RegisterAgentWithController Bean", true, (long)AccService.fACCMonitorInternalPollProperty.value, true);
            this.fAgent.IAgent_getModuleFeedback().debug(kACCMonitorServiceModule, "ACC heartbeat restarted. Period " + AccService.fACCMonitorInternalPollProperty.value);
        }
    }

    protected synchronized void resetRegistrationPoller() {
        if (this.fBehavior.IRegisteredBehavior_getPeriod() != (long)AccService.fACCMonitorInternalPollProperty.value) {
            this.fAgent.IAgent_getModuleFeedback().debug(kACCMonitorServiceModule, "ACC heartbeat changed to " + AccService.fACCMonitorInternalPollProperty.value);
        }
        this.fBehavior.IRegisteredBehavior_setPeriod((long)AccService.fACCMonitorInternalPollProperty.value);
    }

    protected synchronized void startRegistrationPoller(int interval) {
        if (this.fAgentController == null) {
            this.fAgentController = new RegisterAgentWithController(this.fAgent, this, AccService.fACCMonitorPortKeyProperty.value, AccService.fACCMonitorHeartBeatProperty.value);
            this.fBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.fAgentController, "RegisterAgentWithController Bean", true, (long)interval, true);
            this.fAgent.IAgent_getModuleFeedback().info(kACCMonitorServiceModule, "Agent controller registration started with poll interval " + interval + "ms");
        }
    }

    final class ACCMonitorEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;
        private IAgent fAgent;

        ACCMonitorEnabledConfigurationProperty(IAgent agent) {
            super(AccService.kACCMonitorEnabledKey, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kACCMonitorServiceModule, agent.IAgent_getStringLocalizer());
            this.fAgent = agent;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
            if (this.value) {
                AccService.this.startRegistrationPoller(15000);
            } else {
                AccService.this.stopRegistrationPoller();
            }
        }

        public final boolean isEnabled() {
            return this.value;
        }
    }

    final class ACCMonitorHeartBeatProperty
    extends PositiveIntegerConfigurationProperty {
        volatile int value;

        ACCMonitorHeartBeatProperty(IAgent agent) {
            super(AccService.kACCMonitorHeartBeat, Integer.valueOf(1440), agent.IAgent_getModuleFeedback(), kACCMonitorServiceModule, agent.IAgent_getStringLocalizer());
            this.value = 1440;
            if (AccService.this.fAgentController != null) {
                AccService.this.fAgentController.setHeartBeat(this.value);
            }
        }

        public void set(Object newValue) {
            this.value = (Integer)newValue;
            if (AccService.this.fAgentController != null) {
                AccService.this.fAgentController.setHeartBeat(this.value);
            }
        }
    }

    final class ACCMonitorInternalPollProperty
    extends PositiveIntegerConfigurationProperty {
        volatile int value;

        ACCMonitorInternalPollProperty(IAgent agent) {
            super(AccService.kACCMonitorInternalPoll, Integer.valueOf(300000), agent.IAgent_getModuleFeedback(), kACCMonitorServiceModule, agent.IAgent_getStringLocalizer());
            this.value = 300000;
        }

        public void set(Object newValue) {
            int newiValue = (Integer)newValue;
            AccService.this.fAgent.IAgent_getModuleFeedback().debug(kACCMonitorServiceModule, "Internal poll interval is " + newiValue);
            if (AccService.this.fAgentController != null && this.value != newiValue) {
                AccService.this.stopRegistrationPoller();
                AccService.this.startRegistrationPoller(newiValue);
            }
            this.value = newiValue;
        }
    }

    final class ACCMonitorPortKeyProperty
    extends PositiveIntegerConfigurationProperty {
        volatile int value;

        ACCMonitorPortKeyProperty(IAgent agent) {
            super(AccService.kACCMonitorPortKey, Integer.valueOf(51914), agent.IAgent_getModuleFeedback(), kACCMonitorServiceModule, agent.IAgent_getStringLocalizer());
            this.value = 51914;
            if (AccService.this.fAgentController != null) {
                AccService.this.fAgentController.setPort(this.value);
            }
        }

        public void set(Object newValue) {
            this.value = (Integer)newValue;
            if (AccService.this.fAgentController != null) {
                AccService.this.fAgentController.setPort(this.value);
            }
        }
    }
}

