/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.agent.jvmprovider;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.gcmonitor.agent.jvmprovider.BaseException;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProvider;
import com.wily.introscope.gcmonitor.instrumentation.ApplicationException;
import com.wily.introscope.gcmonitor.instrumentation.GCCollector;
import com.wily.introscope.gcmonitor.instrumentation.GCGenerics;
import com.wily.introscope.gcmonitor.instrumentation.GCMemoryPool;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.metricpublisher.agent.AgentMetricPublisher;
import com.wily.util.feedback.Module;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.List;

public class SunJVMProvider
implements JVMProvider {
    private String fJvmString = "";
    private GCGenerics gcGenerics = null;
    private List<GCCollector> collectors = null;
    private List<GCMemoryPool> memoryPools = null;
    private IAgent fAgent = null;
    private static final Module kSunJVMProviderModule = new Module("SunJVMProvider");

    public SunJVMProvider(IAgent agent, String name) {
        this.fJvmString = name;
        this.fAgent = agent;
    }

    @Override
    public void getGCInformation() {
        this.gcGenerics = new GCGenerics(this.fJvmString);
        List garbageCollectorMXBeans = this.getGarbageCollectorMXBeans();
        this.collectors = new ArrayList<GCCollector>();
        for (GarbageCollectorMXBean gcMXbean : garbageCollectorMXBeans) {
            if (this.gcGenerics != null) {
                this.gcGenerics.setfGcPolicy(gcMXbean.getName());
            }
            GCCollector collector = new GCCollector(gcMXbean);
            this.collectors.add(collector);
        }
        List memoryPoolMXBeans = this.getMemoryPoolMXBeans();
        this.memoryPools = new ArrayList<GCMemoryPool>();
        for (MemoryPoolMXBean mxBean : memoryPoolMXBeans) {
            if (!mxBean.getType().name().equals("HEAP") && (!mxBean.getType().name().equals("NON_HEAP") || !mxBean.getName().contains("Perm Gen") && !mxBean.getName().contains("Metaspace"))) continue;
            GCMemoryPool memoryPool = new GCMemoryPool(mxBean);
            this.memoryPools.add(memoryPool);
        }
    }

    @Override
    public void publishMetricValues(boolean useCachedValues) {
        if (this.gcGenerics != null) {
            this.gcGenerics.publish(useCachedValues);
        }
        for (GCCollector collector : this.collectors) {
            if (collector == null) continue;
            collector.publishMetricValues(useCachedValues);
        }
        for (GCMemoryPool gcMemoryPool : this.memoryPools) {
            if (gcMemoryPool == null) continue;
            gcMemoryPool.publishMetricValues(useCachedValues);
        }
    }

    @Override
    public void destroyMetrics() {
        try {
            DataAccumulatorFactory accumulatorFactory = ((AgentMetricPublisher)MetricPublisherFactory.getInstance().getMetricPublisher()).getAccumulatorFactory();
            if (this.gcGenerics != null) {
                this.gcGenerics.turnOffMetrics(accumulatorFactory);
            }
            for (GCCollector collector : this.collectors) {
                collector.turnOffMetrics(accumulatorFactory);
            }
            for (GCMemoryPool gcMemoryPool : this.memoryPools) {
                gcMemoryPool.turnOffMetrics(accumulatorFactory);
            }
        }
        catch (ApplicationException e) {
            this.fAgent.IAgent_getModuleFeedback().error(kSunJVMProviderModule, "Unable to turn off GC Monitor metrics reporting", (Throwable)e);
            throw new BaseException(e);
        }
    }

    protected List getGarbageCollectorMXBeans() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        return garbageCollectorMXBeans;
    }

    protected List getMemoryPoolMXBeans() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        return memoryPoolMXBeans;
    }

    protected int getMemoryPoolsSize() {
        return this.memoryPools.size();
    }

    protected int getCollectorsSize() {
        return this.collectors.size();
    }

    protected GCGenerics getGcGenerics() {
        return this.gcGenerics;
    }

    protected GCCollector getCollector(int index) {
        return this.collectors.get(index);
    }

    protected GCMemoryPool getMemoryPool(int index) {
        return this.memoryPools.get(index);
    }
}

