/*
 * Decompiled with CFR 0.152.
 */
package com.wily.debug.profiler;

import com.wily.debug.profiler.IHeapProfiler;
import com.wily.debug.profiler.IProfiler;
import com.wily.debug.profiler.jprobe.JProbeHeapProfilerWrapper;
import com.wily.debug.profiler.jprobe.JProbePerformanceProfilerWrapper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;

public class ProfilerFactory {
    public static IProfiler newJProbePerformanceProfilerInstance(IModuleFeedbackChannel feedback) {
        IProfiler result = null;
        try {
            result = new JProbePerformanceProfilerWrapper(feedback);
        }
        catch (Throwable t) {
            feedback.warn("could not load the JProbe Performance API wrapper");
            feedback.error(t);
            result = new DevNullProfilerAPIWrapper();
        }
        return result;
    }

    public static IProfiler newPerformanceProfilerInstanceFromProperties(IModuleFeedbackChannel feedback, IndexedProperties properties, String keyPrefix) {
        IProfiler result;
        boolean enabled = properties.getBooleanProperty(keyPrefix + ".profiler.performance.enable");
        if (!enabled) {
            result = new DevNullProfilerAPIWrapper();
        } else {
            String which = properties.getProperty(keyPrefix + ".profiler.performance.type", "jprobe");
            if (!which.equalsIgnoreCase("jprobe")) {
                feedback.warn("ignoring performance profiler request for unsupported profiler type of " + which);
                result = new DevNullProfilerAPIWrapper();
            } else {
                result = ProfilerFactory.newJProbePerformanceProfilerInstance(feedback);
            }
        }
        return result;
    }

    public static IHeapProfiler newJProbeHeapProfilerInstance(IModuleFeedbackChannel feedback) {
        IHeapProfiler result = null;
        try {
            result = new JProbeHeapProfilerWrapper(feedback);
        }
        catch (Throwable t) {
            feedback.warn("could not load the JProbe Heap API wrapper");
            feedback.error(t);
            result = new DevNullProfilerAPIWrapper();
        }
        return result;
    }

    public static IHeapProfiler newHeapProfilerInstanceFromProperties(IModuleFeedbackChannel feedback, IndexedProperties properties, String keyPrefix) {
        IHeapProfiler result;
        boolean enabled = properties.getBooleanProperty(keyPrefix + ".profiler.heap.enable");
        if (!enabled) {
            result = new DevNullProfilerAPIWrapper();
        } else {
            String which = properties.getProperty(keyPrefix + ".profiler.heap.type", "jprobe");
            if (!which.equalsIgnoreCase("jprobe")) {
                feedback.warn("ignoring heap profiler request for unsupported profiler type of " + which);
                result = new DevNullProfilerAPIWrapper();
            } else {
                result = ProfilerFactory.newJProbeHeapProfilerInstance(feedback);
            }
        }
        return result;
    }

    private static class DevNullProfilerAPIWrapper
    implements IProfiler,
    IHeapProfiler {
        private DevNullProfilerAPIWrapper() {
        }

        public boolean IProfiler_stopRecording() {
            return false;
        }

        public boolean IProfiler_startRecording() {
            return false;
        }

        public boolean IProfiler_isCurrentlyRecording() {
            return false;
        }

        public boolean IProfiler_clear() {
            return false;
        }

        public boolean IProfiler_saveSnapshot(String baseName) {
            return false;
        }

        public boolean IHeapProfiler_setCheckpoint() {
            return false;
        }

        public boolean IHeapProfiler_clearCheckpoint() {
            return false;
        }
    }
}

