/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Channel;
import com.wily.EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import com.wily.util.concurrent.IPriorityExecutor;

public class ThreadPriorityExecutor
extends QueuedExecutor
implements IPriorityExecutor {
    public ThreadPriorityExecutor(String name) {
        super((Channel)new BoundedPriorityQueue(null));
    }

    public void IPriorityExecutor_execute(Runnable command, int priority) throws InterruptedException {
        PriorityRunnable runAtPriority = new PriorityRunnable(command, priority);
        this.execute(runAtPriority);
    }

    public void IPriorityExecutor_stop() {
        this.shutdownNow();
    }

    public void IPriorityExecutor_stopAfterProcessingQueue() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks();
    }

    public int IPriorityExecutor_getMaxParallelExecutors() {
        return 1;
    }

    private static class PriorityRunnable
    implements Runnable,
    Comparable {
        Runnable fCommand;
        int fPriority;

        public PriorityRunnable(Runnable command, int priority) {
            this.fCommand = command;
            this.fPriority = priority;
        }

        public void run() {
            this.fCommand.run();
        }

        public int compareTo(Object o) {
            return this.fPriority - ((PriorityRunnable)o).fPriority;
        }
    }
}

