/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.event.EventMarker;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AListenerEvent {
    private static final long serialVersionUID = -3128961452652695439L;
    private final transient int fSerialNumber;
    private int fClassID;
    private int fEventID;
    private transient EventMarker fEventMarker;

    protected AListenerEvent(int serialNumber, int classID, int eventID) {
        this.fSerialNumber = serialNumber;
        this.fClassID = classID;
        this.fEventID = eventID;
        this.fEventMarker = null;
    }

    protected AListenerEvent(int serialNumber) {
        this(serialNumber, -1, -1);
    }

    public int getSerialNumber() {
        return this.fSerialNumber;
    }

    public int getClassID() {
        return this.fClassID;
    }

    public int getEventID() {
        return this.fEventID;
    }

    public EventMarker getEventMarker() {
        Assertion.wilyAssert(this.fEventMarker != null);
        return this.fEventMarker;
    }

    void setEventMarker(EventMarker eventMarker) {
        Assertion.wilyAssert(this.fEventMarker == null);
        this.fEventMarker = eventMarker;
    }

    public String toString() {
        return "AListenerEvent: serial: " + this.fSerialNumber + " classID: " + this.fClassID + " id: " + this.fEventID;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fClassID);
        out.writeInt(this.fEventID);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fClassID = in.readInt();
        this.fEventID = in.readInt();
    }
}

