/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedCharacterEncoding;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.xml.BadlyFormedXMLException;
import com.wily.util.xml.BasicXMLErrorHandler;
import com.wily.util.xml.XMLQualifier;
import com.wily.wilyassert.Assertion;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAssistant {
    private static final String kXmlnsXSI = "xmlns:xsi";
    private static final String kXSINoNamespaceSchemaLocation = "xsi:noNamespaceSchemaLocation";
    private static final String kSuperDocumentName = "SuperDocument";
    private static final String kSuperDocumentRootElementName = "SuperDocument";
    private static final String kSchemaValidationFeature = "http://apache.org/xml/features/validation/schema";
    private static final String kJAXPSchemaLanguage = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String kW3CXMLSchema = "http://www.w3.org/2001/XMLSchema-instance";

    public static Element createDOMElementForInteger(Document doc, String elementName, int intValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Integer.toString(intValue));
    }

    public static Element createDOMElementForDouble(Document doc, String elementName, double doubleValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Double.toString(doubleValue));
    }

    public static Element createDOMElementForLong(Document doc, String elementName, long longValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Long.toString(longValue));
    }

    public static Element createDOMElementForString(Document doc, String elementName, String stringValue) {
        if (stringValue == null) {
            stringValue = "";
        }
        Element newElement = doc.createElement(elementName);
        Text newText = doc.createTextNode(stringValue);
        newElement.appendChild(newText);
        return newElement;
    }

    public static Element createDOMElementForBoolean(Document doc, String elementName, boolean booleanValue) {
        String booleanAsString = new Boolean(booleanValue).toString();
        return XMLAssistant.createDOMElementForString(doc, elementName, booleanAsString);
    }

    public static int parseDOMElementAsInteger(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Integer.parseInt(elementValue);
    }

    public static double parseDOMElementAsDouble(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Double.valueOf(elementValue);
    }

    public static long parseDOMElementAsLong(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Long.valueOf(elementValue);
    }

    public static String parseDOMElementAsString(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = null;
        Node contentNode = element.getFirstChild();
        if (contentNode != null) {
            elementValue = contentNode.getNodeValue();
        }
        return elementValue;
    }

    public static boolean parseDOMElementAsBoolean(Element element, String expectedElementName) throws BadlyFormedXMLException {
        String stringValue = XMLAssistant.parseDOMElementAsString(element, expectedElementName);
        return Boolean.valueOf(stringValue);
    }

    public static Document getDocument(String schemaFile, String rootNodeName) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().newDocument();
        Element root = document.createElement(rootNodeName);
        root.setAttribute(kXmlnsXSI, kW3CXMLSchema);
        root.setAttribute(kXSINoNamespaceSchemaLocation, schemaFile);
        document.appendChild(root);
        return document;
    }

    public static DOMImplementation getDOMImplementation() {
        DOMImplementation implementation = null;
        try {
            implementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException pce) {
            Assertion.unimplemented("Should not get a ParserConfigurationException");
        }
        return implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeDocumentUsingSunXerces(Document xmlDoc, Writer writer) throws IOException {
        OutputFormat of = new OutputFormat();
        of.setLineSeparator("\n");
        of.setIndent(4);
        of.setIndenting(true);
        of.setLineWidth(0);
        XMLSerializer serializer = new XMLSerializer(writer, of);
        try {
            serializer.serialize(xmlDoc);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static void serializeDocumentThroughUTF8(Document xmlDoc, File file) throws IOException {
        XMLAssistant.serializeDocumentThroughUTF8(xmlDoc, new FileOutputStream(file));
    }

    public static void serializeDocumentThroughUTF8(Document xmlDoc, OutputStream stream) throws IOException {
        OutputStreamWriter osw = ExtendedCharacterEncoding.getUTF8OutputStreamWriter(stream);
        PrintWriter writer = new PrintWriter(osw);
        XMLAssistant.serializeDocument(xmlDoc, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeDocument(Document xmlDoc, Writer writer) throws IOException {
        OutputFormat of = new OutputFormat();
        of.setLineSeparator("\n");
        of.setIndent(4);
        of.setIndenting(true);
        of.setLineWidth(0);
        XMLSerializer serializer = new XMLSerializer(writer, of);
        try {
            serializer.serialize(xmlDoc);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocumentThroughUTF8(new FileInputStream(file), validate, null, null, null);
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocumentThroughUTF8(new FileInputStream(file), validate, entityResolver, null, null);
    }

    public static Document parseDocumentThroughUTF8(InputStream inputStream, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocumentThroughUTF8(inputStream, validate, entityResolver, null, null);
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback, IStringLocalizer stringLocalizer) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocumentThroughUTF8(new FileInputStream(file), validate, entityResolver, moduleFeedback, stringLocalizer);
    }

    public static Document parseDocumentThroughUTF8(InputStream inputStream, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback, IStringLocalizer stringLocalizer) throws IOException, SAXException, ParserConfigurationException {
        Document document = null;
        InputStreamReader utf8Reader = ExtendedCharacterEncoding.getUTF8InputStreamReader(inputStream);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (validate) {
            factory.setValidating(true);
            factory.setAttribute(kSchemaValidationFeature, new Boolean(true));
            factory.setAttribute(kJAXPSchemaLanguage, kW3CXMLSchema);
            factory.setNamespaceAware(true);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (validate) {
            builder.setErrorHandler(new BasicXMLErrorHandler(false, false, moduleFeedback, stringLocalizer));
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        document = builder.parse(new InputSource(utf8Reader));
        return document;
    }

    public static Document createSuperDocument(Document[] subDocuments) throws ParserConfigurationException {
        Assertion.wilyAssert(subDocuments != null);
        DOMImplementation implementation = null;
        DocumentType superDocumentType = null;
        Document superDocument = null;
        Element superDocumentRoot = null;
        Element currentSubDocumentRoot = null;
        if (subDocuments.length != 0) {
            implementation = XMLAssistant.getDOMImplementation();
            superDocumentType = implementation.createDocumentType("SuperDocument", null, null);
            superDocument = implementation.createDocument(subDocuments[0].getNamespaceURI(), "SuperDocument", superDocumentType);
            superDocumentRoot = superDocument.getDocumentElement();
            for (int i = 0; i < subDocuments.length; ++i) {
                currentSubDocumentRoot = subDocuments[i].getDocumentElement();
                superDocumentRoot.appendChild(superDocument.importNode(currentSubDocumentRoot, true));
            }
        }
        return superDocument;
    }

    public static Document[] createSubDocuments(Document superDocument, DocumentType documentTypeTemplate) throws ParserConfigurationException {
        Assertion.wilyAssert(superDocument != null);
        Assertion.wilyAssert(superDocument.getDocumentElement() != null);
        DOMImplementation currentImplementation = null;
        Document currentSubDocument = null;
        NodeList subDocumentRoots = superDocument.getDocumentElement().getChildNodes();
        Element currentSubDocumentRoot = null;
        Vector<Document> subDocumentsVector = new Vector<Document>();
        Document[] subDocumentsArray = null;
        DocumentType subDocumentType = null;
        for (int i = 0; i < subDocumentRoots.getLength(); ++i) {
            if (subDocumentRoots.item(i).getNodeType() != 1) continue;
            currentSubDocumentRoot = (Element)subDocumentRoots.item(i);
            currentImplementation = XMLAssistant.getDOMImplementation();
            subDocumentType = null;
            if (documentTypeTemplate != null) {
                subDocumentType = currentImplementation.createDocumentType(documentTypeTemplate.getName(), documentTypeTemplate.getPublicId(), documentTypeTemplate.getSystemId());
            }
            currentSubDocument = currentImplementation.createDocument(superDocument.getNamespaceURI(), currentSubDocumentRoot.getNodeName(), subDocumentType);
            currentSubDocumentRoot = (Element)currentSubDocument.importNode(currentSubDocumentRoot, true);
            currentSubDocument.replaceChild(currentSubDocumentRoot, currentSubDocument.getDocumentElement());
            subDocumentsVector.add(currentSubDocument);
        }
        subDocumentsArray = new Document[subDocumentsVector.size()];
        subDocumentsVector.toArray(subDocumentsArray);
        return subDocumentsArray;
    }

    public static List getDirectDescendentElementsByTagName(Element element, String name) {
        Assertion.wilyAssert(element != null);
        Assertion.wilyAssert(name != null);
        ArrayList<Element> newList = new ArrayList<Element>();
        NodeList origList = element.getElementsByTagName(name);
        for (int i = 0; i < origList.getLength(); ++i) {
            Element listElement = (Element)origList.item(i);
            if (!listElement.getParentNode().equals(element)) continue;
            newList.add(listElement);
        }
        return newList;
    }

    public static Element createDOMElementForColor(Document doc, String elementName, Color color) {
        return XMLAssistant.createDOMElementForInteger(doc, elementName, color.getRGB());
    }

    public static Color parseDOMElementAsColor(Element colorElement, String expectedElementName) throws BadlyFormedXMLException {
        int rgbValue = XMLAssistant.parseDOMElementAsInteger(colorElement, expectedElementName);
        return new Color(rgbValue, true);
    }
}

