/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml.converter;

import com.wily.util.xml.XMLAssistant;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XMLConverter {
    private InputStream[] fXSLTInputStreams;
    private DocumentType fNewDocumentTypeTemplate;

    public XMLConverter(InputStream[] xsltInputStreams, DocumentType newDocumentTypeTemplate) {
        this.fXSLTInputStreams = xsltInputStreams;
        this.fNewDocumentTypeTemplate = newDocumentTypeTemplate;
    }

    protected XMLConverter() {
        this.fXSLTInputStreams = new InputStream[0];
        this.fNewDocumentTypeTemplate = null;
    }

    protected void finishInitialization(InputStream[] xsltInputStreams, DocumentType newDocumentTypeTemplate) {
        this.fXSLTInputStreams = xsltInputStreams;
        this.fNewDocumentTypeTemplate = newDocumentTypeTemplate;
    }

    public Document[] convert(Document[] documents) throws IOException, TransformerException, ParserConfigurationException {
        Document[] convertedDocuments = new Document[]{};
        if (this.fXSLTInputStreams.length == 0) {
            convertedDocuments = documents;
        } else if (documents.length > 0) {
            Document superDocument;
            Document currentDocument = superDocument = XMLAssistant.createSuperDocument(documents);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult currentResult = null;
            for (int i = 0; i < this.fXSLTInputStreams.length; ++i) {
                StreamSource xsltSource = new StreamSource(this.fXSLTInputStreams[i]);
                Transformer transformer = transformerFactory.newTransformer(xsltSource);
                DOMSource currentDocumentDOMSource = new DOMSource(currentDocument);
                currentResult = new DOMResult();
                transformer.transform(currentDocumentDOMSource, currentResult);
                currentDocument = (Document)currentResult.getNode();
            }
            convertedDocuments = XMLAssistant.createSubDocuments(currentDocument, this.fNewDocumentTypeTemplate);
        }
        return convertedDocuments;
    }
}

