/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jaxrs;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class JaxrsNameFormatter
implements INameFormatter {
    private static IAgent fAgent;
    private static IModuleFeedbackChannel fModuleFeedback;
    private static final Module kModule;
    public static final String NAMESPACE_NAME_HOLDER = "{namespace}";
    public static final String OPERATION_NAME_HOLDER = "{operationname}";
    public static final String HTTPMETHOD_NAME = "HTTP RESTful Method";

    static {
        kModule = new Module("JaxrsWebservices");
    }

    public JaxrsNameFormatter(IAgent agent) {
        fAgent = agent;
        fModuleFeedback = fAgent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        block2: {
            try {
                String namespace = (String)data.get("namespace");
                name = StringUtils.replace((String)name, (String)NAMESPACE_NAME_HOLDER, (String)namespace);
                String operationname = (String)data.get("operationname");
                name = StringUtils.replace((String)name, (String)OPERATION_NAME_HOLDER, (String)operationname);
                name = name.replace(':', '%');
            }
            catch (Exception e) {
                fModuleFeedback.error(kModule, "Cannot format JAX_RS metric name : " + e.getMessage());
                if (!fModuleFeedback.isDebugEnabled(kModule)) break block2;
                fModuleFeedback.debug(kModule, "Cannot format JAX_RS metric name : ", (Throwable)e);
            }
        }
        return name;
    }
}

