/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.KConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class WebServiceBlamePointTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback,
KConstants {
    private IModuleFeedbackChannel logger = null;
    private static final String kServiceTag = "service";

    public WebServiceBlamePointTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebServiceBlamePointTracer:ITracer_startTrace");
        }
        String component = this.getComponentName(data);
        data.setComponentNameAt(component, tracerIndex);
        String nameSpace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        String serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName == null || operationName.length() == 0) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebServiceBlamePointTracer:ITracer_startTrace : operationname is null, using method name");
            }
            operationName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebServiceBlamePointTracer : namespace" + nameSpace);
            this.logger.debug("WebServiceBlamePointTracer : serviceName" + serviceName);
            this.logger.debug("WebServiceBlamePointTracer : operationName" + operationName);
        }
        if (serviceName != null && serviceName.length() > 0) {
            this.getComponentTracer().addExtraParameter("namespace", serviceName);
        }
        if (nameSpace != null && nameSpace.length() > 0) {
            this.getComponentTracer().addExtraParameter("namespace", nameSpace);
        }
        if (operationName != null && operationName.length() > 0) {
            this.getComponentTracer().addExtraParameter("operationname", operationName);
        }
        if (!data.isParameterCallbackInitialized()) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
        }
        this.doStartBlamePointTrace(tracerIndex, data, component);
        if (this.isServiceContext()) {
            this.getComponentTracer().setComponentMetricPropagateFlag(component, 1);
        }
    }

    protected boolean isServiceContext() {
        return this.getParameter(kServiceTag) != null;
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String nameSpace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        String serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName == null || operationName.length() == 0) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebServiceBlamePointTracer:ITracer_startTrace : operationname is null, using method name");
            }
            operationName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebServiceBlamePointTracer : namespace" + nameSpace);
            this.logger.debug("WebServiceBlamePointTracer : serviceName" + serviceName);
            this.logger.debug("WebServiceBlamePointTracer : operationName" + operationName);
        }
        if (serviceName != null && serviceName.length() > 0) {
            parameters.put("namespace", serviceName);
        }
        if (nameSpace != null && nameSpace.length() > 0) {
            parameters.put("namespace", nameSpace);
        }
        if (operationName != null && operationName.length() > 0) {
            parameters.put("operationname", operationName);
        }
    }
}

