/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSClientCorrelationTracer;
import com.wily.util.properties.AttributeListing;

public class WebsphereClientCorrelationTracer
extends WSClientCorrelationTracer {
    boolean doFinish = true;

    public WebsphereClientCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        if (!WSMUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        Object messageContext = null;
        Class<?> OMAbstractFactory = null;
        Class<?> OMNamespace = null;
        Class<?> OMNode = null;
        try {
            messageContext = data.getInvocationParameterAsObject(0);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereClientCorrelationTracer::ITracer_startTrace messageContext  = " + messageContext);
            }
            if (messageContext != null) {
                Object soapEnvelope;
                Object transportOut = WSMUtils.invokeMethodOnObject(messageContext, "getProperty", new Class[]{String.class}, new Object[]{"TRANSPORT_OUT"});
                if (transportOut != null) {
                    this.doFinish = false;
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("WebsphereClientCorrelationTracer::transportOut==null");
                    }
                    return;
                }
                this.doFinish = true;
                OMAbstractFactory = Class.forName("org.apache.axiom.om.OMAbstractFactory", false, Thread.currentThread().getContextClassLoader());
                OMNamespace = Class.forName("org.apache.axiom.om.OMNamespace", false, Thread.currentThread().getContextClassLoader());
                Class.forName("org.apache.axiom.om.OMElement", false, Thread.currentThread().getContextClassLoader());
                OMNode = Class.forName("org.apache.axiom.om.OMNode", false, Thread.currentThread().getContextClassLoader());
                Object factory = WSMUtils.invokeMethodOnClass(OMAbstractFactory, "getOMFactory");
                Object wilyNS = WSMUtils.invokeMethodOnObject(factory, "createOMNamespace", new Class[]{String.class, String.class}, new Object[]{"http://www.ca.com/apm", ""});
                Object corElement = WSMUtils.invokeMethodOnObject(factory, "createOMElement", new Class[]{String.class, OMNamespace}, new Object[]{"WSCorIDSOAPHeader", wilyNS});
                CorrelationId corIdTmp = new CorrelationId();
                String correlationId = corIdTmp.getOutgoingCorrelationIdStrippedForHeader();
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("WebsphereClientCorrelationTracer::CorID: " + correlationId);
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = "CorID";
                objectArray[1] = correlationId;
                WSMUtils.invokeMethodOnObject(corElement, "addAttribute", new Class[]{String.class, String.class, OMNamespace}, objectArray);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("WebsphereClientCorrelationTracer::Got addAttribute.");
                }
                if ((soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope")) == null) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("WebsphereClientCorrelationTracer:: soapEnvelope==null");
                    }
                } else if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("WebsphereClientCorrelationTracer:: soapEnvelope class=" + soapEnvelope.getClass());
                }
                Object soapheader = WSMUtils.invokeMethodOnObject(soapEnvelope, "getHeader");
                WSMUtils.invokeMethodOnObject(soapheader, "addChild", new Class[]{OMNode}, new Object[]{corElement});
            }
        }
        catch (Throwable bomb) {
            String message = "WebsphereClientCorrelationTracer ITracer_startTrace exception:  " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebsphereClientCorrelationTracer:: ITracer_finishTrace");
        }
        if (this.doFinish && WSMUtils.correlationSOAPInsertionEnabled()) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }
}

