/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers;

import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.extension.wsdm71mmi.FaultInfo;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import java.util.Arrays;
import javax.xml.soap.SOAPMessage;

public class WsdmMessageContext {
    private static String ENVELOPE = "Envelope";
    private static String BODY = "Body";
    private static String FAULT = "Fault";
    private static String FAULTCODE = "faultcode";
    private static String FAULTACTOR = "faultactor";
    private static String FAULTSTRING = "faultstring";
    private static String FAULTNODE = "faultnode";
    private static String FAULTDETAIL = "detail";
    private static String FAULTSOAPPREFIX = "soapenv";
    private static String FAULTNS = "http://schemas.xmlsoap.org/soap/envelope/";
    private String serviceName;
    private String namespace;
    private String operationName;
    private String portName;
    private long beginTime;
    private long endTime = 0L;
    private String requestorLocation;
    protected String requestMessage = null;
    protected String responseMessage = null;
    private FaultInfo faultInfo = null;
    private String transactionId;
    private int observationType;
    private String userID;
    private String[] general;
    private String serviceDependencyId;
    private String observerIp;
    private boolean toObservationProcessor = false;
    private SOAPMessage requestSOAPMessage;
    private SOAPMessage responseSOAPMessage;
    private String correlationId = "COR_ID_UNSET";
    protected static WsdmLogger log = new WsdmLogger();
    public static final String TRANSACTION_ID = "transaction_id";
    public static final String OPERATION_NAME = "operation_name";
    public static final String OPERATION_NAMESPACE = "operation_namespace";
    public static final String SERVICE_ENDPOINT = "service_endpoint";
    public static final String REQUESTOR_LOCATION = "requestor_location";
    public static final String REQUEST_SIZE = "request_size";
    public static final String RESPONSE_SIZE = "response_size";
    public static final String REQUEST_TIME = "request_time";
    public static final String REQUEST_DURATION = "duration";
    public static final String REQUEST_MESSAGE = "request_message";
    public static final String RESPONSE_MESSAGE = "response_message";
    public static final String HANDLER_TYPE = "handler_type";
    public static final String OBSERVATION_TYPE = "observation_type";

    private static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public WsdmMessageContext(int observationType) {
        this.setBeginTime(System.currentTimeMillis());
        this.setObservationType(observationType);
    }

    public WsdmMessageContext(String observationType) {
        int oType;
        this.setBeginTime(System.currentTimeMillis());
        try {
            oType = Integer.parseInt(observationType);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Observation type underterminable");
            oType = 1;
        }
        this.setObservationType(oType);
    }

    public String getOperationNameSpace() {
        return this.namespace;
    }

    public void setOperationNameSpace(String name) {
        if (name == null || name.equals("")) {
            this.namespace = "UnknownServiceName";
        }
        this.namespace = name;
        WSNameCache.setNamespaceURI(name);
        if (log.isDebugLogging().booleanValue()) {
            log.debug("setOperationNameSpace::operation name space=" + name);
        }
    }

    public void setServiceName(String name) {
        if (name == null || name.equals("")) {
            this.serviceName = "UnknownServiceName";
        }
        this.serviceName = name;
        WSNameCache.setServiceName(name);
        if (log.isDebugLogging().booleanValue()) {
            log.debug("setServiceName::service name=" + name);
        }
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
        WSNameCache.setOperationName(operationName);
        if (log.isDebugLogging().booleanValue()) {
            log.debug("setOperationName::operation name=" + operationName);
        }
    }

    public String getObserverIp() {
        return this.observerIp;
    }

    public void setObserverIp(String observerIp) {
        this.observerIp = observerIp;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getRequestorLocation() {
        return this.requestorLocation;
    }

    public void setRequestorLocation(String requestorLocation) {
        this.requestorLocation = requestorLocation;
    }

    public void setFaultInfo(FaultInfo faultInfo) {
        this.faultInfo = faultInfo;
    }

    public FaultInfo getFaultInfo() {
        return this.faultInfo;
    }

    protected void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    protected void setHandlerType(String handlerType) {
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setGeneral(String[] general) {
        this.general = general;
    }

    public String[] getGeneral() {
        return this.general;
    }

    public void setServiceDependencyId(String serviceDependencyId) {
        this.serviceDependencyId = serviceDependencyId;
    }

    public String getServiceDependencyId() {
        return this.serviceDependencyId;
    }

    public int getObservationType() {
        return this.observationType;
    }

    public void setObservationType(int observationType) {
        this.observationType = observationType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.beginTime ^ this.beginTime >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (this.faultInfo == null ? 0 : this.faultInfo.hashCode());
        result = 31 * result + WsdmMessageContext.hashCode(this.general);
        result = 31 * result + this.observationType;
        result = 31 * result + (this.observerIp == null ? 0 : this.observerIp.hashCode());
        result = 31 * result + (this.operationName == null ? 0 : this.operationName.hashCode());
        result = 31 * result + (this.portName == null ? 0 : this.portName.hashCode());
        result = 31 * result + (this.requestMessage == null ? 0 : this.requestMessage.hashCode());
        result = 31 * result + (this.requestorLocation == null ? 0 : this.requestorLocation.hashCode());
        result = 31 * result + (this.responseMessage == null ? 0 : this.responseMessage.hashCode());
        result = 31 * result + (this.serviceDependencyId == null ? 0 : this.serviceDependencyId.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = 31 * result + (this.userID == null ? 0 : this.userID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WsdmMessageContext other = (WsdmMessageContext)obj;
        if (this.beginTime != other.beginTime) {
            return false;
        }
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.faultInfo == null ? other.faultInfo != null : !this.faultInfo.equals(other.faultInfo)) {
            return false;
        }
        if (!Arrays.equals(this.general, other.general)) {
            return false;
        }
        if (this.observationType != other.observationType) {
            return false;
        }
        if (this.observerIp == null ? other.observerIp != null : !this.observerIp.equals(other.observerIp)) {
            return false;
        }
        if (this.operationName == null ? other.operationName != null : !this.operationName.equals(other.operationName)) {
            return false;
        }
        if (this.portName == null ? other.portName != null : !this.portName.equals(other.portName)) {
            return false;
        }
        if (this.requestMessage == null ? other.requestMessage != null : !this.requestMessage.equals(other.requestMessage)) {
            return false;
        }
        if (this.requestorLocation == null ? other.requestorLocation != null : !this.requestorLocation.equals(other.requestorLocation)) {
            return false;
        }
        if (this.responseMessage == null ? other.responseMessage != null : !this.responseMessage.equals(other.responseMessage)) {
            return false;
        }
        if (this.serviceDependencyId == null ? other.serviceDependencyId != null : !this.serviceDependencyId.equals(other.serviceDependencyId)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        if (this.transactionId == null ? other.transactionId != null : !this.transactionId.equals(other.transactionId)) {
            return false;
        }
        return !(this.userID == null ? other.userID != null : !this.userID.equals(other.userID));
    }

    public void setRequestSOAPMessage(SOAPMessage message) {
        this.requestSOAPMessage = message;
    }

    public SOAPMessage getRequestSOAPMessage() {
        return this.requestSOAPMessage;
    }

    public void setResponseSOAPMessage(SOAPMessage message) {
        this.responseSOAPMessage = message;
    }

    public SOAPMessage getResponseSOAPMessage() {
        return this.responseSOAPMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }
}

