/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.inherit;

import com.wily.diagnos.cmp.classmatcher.DGCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGInheritedClassMatcher;
import com.wily.diagnos.cmp.classmatcher.FixedCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.introscope.autoprobe.inherit.ClassMatcherTracerGroupMapping;
import com.wily.introscope.autoprobe.inherit.ClassRepository;
import com.wily.introscope.autoprobe.inherit.OneToManyMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassMatcherRepository {
    private Map fClassTracerMapping = new OneToManyMap();
    private ClassRepository fClassRepository;
    private IModuleFeedbackChannel fFeedback;

    public ClassMatcherRepository(CompilerSettingsBuilder settingsBuilder, ClassRepository classRepository, IModuleFeedbackChannel feedback) {
        this.fClassRepository = classRepository;
        this.fFeedback = feedback;
        this.generateClassTracerMapping(settingsBuilder);
    }

    private void generateClassTracerMapping(CompilerSettingsBuilder settingsBuilder) {
        this.fFeedback.debug("Generating class trace mapping");
        HashSet<IClassMatcher> classMatchers = new HashSet<IClassMatcher>();
        Iterator iterator = settingsBuilder.getTracerIterator();
        while (iterator.hasNext()) {
            IClassMatcher matcher;
            DGCompoundClassMatcher compoundMatcher;
            MethodTracerBuilder methodTracerBuilder = (MethodTracerBuilder)iterator.next();
            IClassMatcher classMatcher = methodTracerBuilder.getClassMatcher();
            if (classMatchers.contains(classMatcher)) continue;
            classMatchers.add(classMatcher);
            if (classMatcher instanceof DGInheritedClassMatcher) {
                compoundMatcher = new DGCompoundClassMatcher();
                compoundMatcher.addClassMatcher(classMatcher);
                this.fFeedback.debug("setting compound class matcher for the inherited class matcher");
                methodTracerBuilder.setClassMatcher((IClassMatcher)compoundMatcher);
            }
            if (classMatcher instanceof FixedCompoundClassMatcher) {
                compoundMatcher = ((FixedCompoundClassMatcher)classMatcher).generateMutableMatcher();
                this.fFeedback.debug("converting to dg compound class matcher from fixed compound class matcher");
                methodTracerBuilder.setClassMatcher((IClassMatcher)compoundMatcher);
            }
            if (!((matcher = methodTracerBuilder.getClassMatcher()) instanceof DGCompoundClassMatcher)) continue;
            this.processClassMatcher((DGCompoundClassMatcher)matcher, methodTracerBuilder.getFlag());
        }
    }

    private void processClassMatcher(DGCompoundClassMatcher compoundClassMatcher, TracerGroupBuilder tracerGroup) {
        Iterator classMatcherItr = compoundClassMatcher.getClassMatchers();
        while (classMatcherItr.hasNext()) {
            IClassMatcher innerClassMatcher = (IClassMatcher)classMatcherItr.next();
            if (innerClassMatcher instanceof DGCompoundClassMatcher) {
                this.processClassMatcher((DGCompoundClassMatcher)innerClassMatcher, tracerGroup);
            }
            if (!(innerClassMatcher instanceof DGInheritedClassMatcher)) continue;
            DGInheritedClassMatcher inheritedClassMatcher = (DGInheritedClassMatcher)innerClassMatcher;
            String interfaceName = inheritedClassMatcher.getClassName().getReflectionFriendlyQualifiedNameString();
            this.fFeedback.debug("Inherited Class Matcher found for interface name -" + interfaceName);
            List matchingClasses = this.fClassRepository.getMatchingClasses(interfaceName);
            if (matchingClasses == null) continue;
            this.addMappings(matchingClasses, compoundClassMatcher, tracerGroup);
        }
    }

    private void addMappings(List matchingClasses, DGCompoundClassMatcher compoundClassMatcher, TracerGroupBuilder tracerGroup) {
        int i = 0;
        while (i < matchingClasses.size()) {
            Class matchingClass = (Class)matchingClasses.get(i);
            ClassMatcherTracerGroupMapping matcherInfo = new ClassMatcherTracerGroupMapping(compoundClassMatcher, tracerGroup);
            this.fFeedback.debug("Adding mapping -->" + matchingClass);
            this.fClassTracerMapping.put(matchingClass, matcherInfo);
            ++i;
        }
    }

    public Map getClassMappings() {
        return this.fClassTracerMapping;
    }
}

