/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.inherit;

import com.wily.introscope.autoprobe.inherit.OneToManyMap;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;

public class ClassRepository {
    private Instrumentation fInstrumentation;
    private Map fClassMapping = new OneToManyMap();

    public ClassRepository(Instrumentation in) {
        this.fInstrumentation = in;
        this.generateClassMappings();
    }

    public void generateClassMappings() {
        Class[] allClasses = this.fInstrumentation.getAllLoadedClasses();
        int i = 0;
        while (i < allClasses.length) {
            Class cls = allClasses[i];
            if (cls != null && !cls.isArray() && !cls.isPrimitive()) {
                this.fClassMapping.put(cls.getName(), cls);
            }
            ++i;
        }
    }

    public boolean hasMultipleClasses(String className) {
        List classList = (List)this.fClassMapping.get(className);
        if (classList == null) {
            return false;
        }
        return classList.size() != 1;
    }

    public Class getMatchingClass(String className) {
        List classList = (List)this.fClassMapping.get(className);
        if (classList == null) {
            return null;
        }
        return (Class)classList.get(0);
    }

    public List getMatchingClasses(String className) {
        return (List)this.fClassMapping.get(className);
    }
}

