/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.rave.agent.IListenerContainer;
import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.ds.DataSourceListener;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.HashMap;
import java.util.Map;

class ListenerContainer
implements IListenerContainer {
    protected final Map listeners;
    protected RaveAgent raveAgent;
    protected IAgent coreAgent;
    protected IModuleFeedbackChannel feedback;
    protected IntervalHeartbeat heartbeat;

    ListenerContainer(RaveAgent raveAgent, IAgent coreAgent, IModuleFeedbackChannel feedback, IntervalHeartbeat heartbeat) {
        this.raveAgent = raveAgent;
        this.feedback = feedback;
        this.coreAgent = coreAgent;
        this.heartbeat = heartbeat;
        this.listeners = new HashMap();
    }

    @Override
    public synchronized IDataSourceListener getListener(String dataSourceName, String dataSourceDisplayName, String dataSourceType, boolean deletionSupport, int batchSize) throws StopCollectionException {
        String dataSourceFullName = String.valueOf(dataSourceName) + "_:_" + dataSourceType;
        DataSourceListener listener = (DataSourceListener)this.listeners.get(dataSourceFullName);
        if (listener == null) {
            listener = this.createListener(dataSourceName, dataSourceDisplayName, dataSourceType, deletionSupport, batchSize);
            this.listeners.put(dataSourceFullName, listener);
        }
        return listener;
    }

    protected DataSourceListener createListener(String dataSourceName, String dataSourceDisplayName, String dataSourceType, boolean deletionSupport, int batchSize) throws StopCollectionException {
        return new DataSourceListener(this.raveAgent, this.feedback, dataSourceName, dataSourceDisplayName, dataSourceType, deletionSupport, batchSize, this.coreAgent, this.heartbeat);
    }
}

