/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Latch;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.epa.IXMLHandler;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.transformer.ClassFileTransformer;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.rave.agent.ConfigurationException;
import com.wily.rave.agent.ConnectionManager;
import com.wily.rave.agent.IListenerContainer;
import com.wily.rave.agent.ListenerContainer;
import com.wily.rave.agent.RaveAgentNameMappingHandler;
import com.wily.rave.agent.RaveConfiguration;
import com.wily.rave.agent.config.parser.ConfigFileParser;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import com.wily.rave.agent.ds.classmonitor.ClassTransformer;
import com.wily.rave.agent.ds.classmonitor.ClassTransformerWrapper;
import com.wily.rave.agent.ds.classmonitor.RuntimeClassMonitorConfig;
import com.wily.rave.agent.epa.EPADataSourceContainer;
import com.wily.rave.agent.task.IRaveTask;
import com.wily.rave.agent.task.ITaskId;
import com.wily.rave.agent.task.RaveTaskExecutor;
import com.wily.rave.agent.task.Schedule;
import com.wily.rave.server.api.IWatchedAgent;
import com.wily.util.RaveUtil;
import com.wily.util.XMLFileFilter;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.ModuleFeedbackChannelWrapper;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Map;

public class RaveAgent
implements IAgentService {
    private static final String kCDTransformerPluginType = "cdtransformer";
    private static final String kTransformerOrderKey = "Order";
    private static final int kDefaultTransformerOrder = 0;
    public static final String RAVE_XML_HANDLER_TAG = "changeData";
    private static final String TMP_DIR_NAME = "tmp" + File.separator;
    private static final String DATA_DIR_NAME = "data" + File.separator;
    private static final Module changeDetectorModule = new Module("ChangeDetector");
    private IModuleFeedbackChannel fFeedback = new SystemOutFeedbackChannel("ChangeDetector_uninitialized");
    private IStringLocalizer fLocalizer;
    private IVersion fVersion;
    protected IAgent fCoreAgent;
    protected IntervalHeartbeat fHeartbeat;
    protected IntervalHeartbeat fCompressionHeartbeat;
    private String fTmpDirName;
    private String fDataDirName;
    private RaveConfiguration fRaveConfig;
    private RaveAgentNameMappingHandler fAgentNameMappingHandler;
    private ConnectionManager fConnectionManager;
    private boolean fEpaLoaded;
    private IListenerContainer fListenerContainer;
    private boolean fKillRave = false;
    private Latch fInitialized;
    private ThreadLocal fInitThread;
    private ConfigFileParser parser;
    private static final String kCompressProperty = "introscope.changeDetector.compressEntries.enable";
    private static final String kBatchProperty = "introscope.changeDetector.compressEntries.batchSize";
    private static final long kDefaultExecutionWait = 1000L;
    private static final Integer kDefaultBatchSize = 100;

    public static IModuleFeedbackChannel getCDFeedbackChannel(IAgent agent) {
        return new ModuleFeedbackChannelWrapper(agent.IAgent_getModuleFeedback(), changeDetectorModule);
    }

    public void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        try {
            this.init(agent, true);
        }
        catch (Throwable t) {
            this.fFeedback.error("Caught exception while starting ChangeDetector agent!", t);
            this.shutDown();
        }
    }

    protected synchronized void init(IAgent agent, boolean startHeartbeat) {
        this.fCoreAgent = agent;
        this.fFeedback = RaveAgent.getCDFeedbackChannel(agent);
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fVersion = new IntroscopeVersion(this.fLocalizer);
        this.fInitThread = new ThreadLocal();
        this.fInitThread.set(Boolean.TRUE);
        this.fInitialized = new Latch();
        BooleanConfigurationProperty changeDetectorEnabledParam = new BooleanConfigurationProperty("introscope.changeDetector.enable", Boolean.FALSE, "Rave_Agent_Enabled", this.fFeedback, changeDetectorModule, this.fLocalizer);
        agent.IAgent_getConfigurationManager().add(changeDetectorEnabledParam);
        if (!((Boolean)changeDetectorEnabledParam.getValue()).booleanValue()) {
            this.fFeedback.info("ChangeDetector is currently disabled and won't run. To enable ChangeDetector set the property introscope.changeDetector.enable to true.");
            return;
        }
        this.feedbackStartupMessage();
        try {
            this.fRaveConfig = new RaveConfiguration(this.fFeedback, this.fCoreAgent);
        }
        catch (ConfigurationException e) {
            String msg = "Failed loading ChangeDetector configuration. Shutting down!";
            this.fFeedback.error(msg, (Throwable)((Object)e));
            throw new RuntimeException(msg);
        }
        this.fHeartbeat = new IntervalHeartbeat("ChangeDetector Heartbeat", this.fFeedback, this.fLocalizer);
        this.fListenerContainer = this.createListenerContainer();
        ElementParserHelper.setAgentProps(this.fCoreAgent.IAgent_getIndexedProperties());
        this.createNecessaryDirectories();
        HashSet contexts = new HashSet();
        String dataSourceProfileFileName = this.fRaveConfig.getDataSourceProfileFileName();
        String dataSourceProfileDir = this.fRaveConfig.getDataSourceProfileDir();
        boolean profileLoaded = this.loadDataSourceProfile(contexts, dataSourceProfileFileName, dataSourceProfileDir);
        if (RuntimeClassMonitorConfig.classMonitoringEnabled()) {
            this.registerTransformer(agent);
            final ClassTransformer transformer = ClassTransformer.getTransformer();
            CompressEntriesConfigurationProperty fCompressProperty = new CompressEntriesConfigurationProperty(agent);
            agent.IAgent_getConfigurationManager().add(fCompressProperty);
            final CompressEntriesBatchSizeConfigurationProperty fBatchProperty = new CompressEntriesBatchSizeConfigurationProperty(agent);
            agent.IAgent_getConfigurationManager().add(fBatchProperty);
            if (fCompressProperty.value && startHeartbeat) {
                this.fCompressionHeartbeat = new IntervalHeartbeat("ChangeDetector Compression Heartbeat", this.fFeedback, this.fLocalizer);
                this.fCompressionHeartbeat.start();
                final ClassTransformer.IInfoContainerProcessor processor = new ClassTransformer.IInfoContainerProcessor(){

                    @Override
                    public ClassInfoContainer processEntry(ClassInfoContainer entry) {
                        if (entry != null && !entry.isCompressed()) {
                            return ClassInfoContainer.getCompressedEntry(entry);
                        }
                        return entry;
                    }

                    @Override
                    public void onGetEntryException(Exception e) {
                        RaveAgent.this.fFeedback.debug("Interrupted whilst compressing classes list");
                    }

                    @Override
                    public void onPutEntryException(String className, Exception e) {
                        RaveAgent.this.fFeedback.warn(RaveAgent.this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Rave_Agent_Failed_To_Save_Class", className));
                    }
                };
                new WaitAndExecuteBehavior(this.fCompressionHeartbeat, 1000L, "Compress Change Detector Entries"){

                    @Override
                    protected boolean execute() {
                        int i = 0;
                        int size = (Integer)fBatchProperty.getValue();
                        while (i++ < size) {
                            try {
                                if (transformer.processNextClass(processor)) continue;
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        return false;
                    }
                };
            }
        }
        ConnectionManager.waitIsengardReady(this.fCoreAgent, this.fFeedback, this.fRaveConfig.getIsengardWaitTimeInSec(), this.fRaveConfig.getIsengardWaitCount());
        this.fConnectionManager = new ConnectionManager(this, this.fCoreAgent, this.fFeedback);
        this.fAgentNameMappingHandler = new RaveAgentNameMappingHandler(this.fCoreAgent, this.fHeartbeat, this.fFeedback, this.fRaveConfig.getRaveAgentID());
        boolean bl = this.fEpaLoaded = this.fRaveConfig.isEPAAgentEnabled() ? this.doEPAgentRegistration() : false;
        if (!profileLoaded && !this.fEpaLoaded) {
            this.fFeedback.error("ChangeDetector not running within an EPA agent and no data source profile provided. ChangeDetector will shut down!");
            this.shutDown();
            return;
        }
        this.fInitialized.release();
        if (startHeartbeat) {
            this.fHeartbeat.start();
        }
        this.fFeedback.info("Done initializing ChangeDetector!");
    }

    private void registerTransformer(IAgent agent) {
        try {
            ClassTransformerWrapper transformer = new ClassTransformerWrapper(agent);
            TransformerAdministrator transformerAdministrator = agent.IAgent_getTransformerAdministrator();
            Assertion.wilyAssert(false);
            ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
            Assertion.wilyAssert(false);
            IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kCDTransformerPluginType);
            int i = 0;
            while (i < plugins.length) {
                int order = this.getOrderParameter(plugins[i]);
                transformerAdministrator.registerTransformer(plugins[i].IPlugin_getName(), order, (ClassFileTransformer)transformer);
                ++i;
            }
        }
        catch (ClassFileTransformerShouldNotRunException classFileTransformerShouldNotRunException) {
            this.fFeedback.warn(changeDetectorModule, "Failed to create class transformer");
        }
    }

    private final int getOrderParameter(IPlugin plugin) {
        IStringDictionaryReader attributesReader = plugin.IPlugin_getAttributes();
        String orderString = attributesReader.getValue(kTransformerOrderKey);
        if (orderString != null) {
            try {
                return Integer.parseInt(orderString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    protected IListenerContainer createListenerContainer() {
        return new ListenerContainer(this, this.fCoreAgent, this.fFeedback, this.fHeartbeat);
    }

    protected boolean loadDataSourceProfile(HashSet contexts, String dataSourceProfileFileName, String dataSourceProfileDir) {
        boolean foundFile = false;
        try {
            File raveConfigDir = null;
            if (dataSourceProfileDir != null) {
                raveConfigDir = new File(dataSourceProfileDir);
                if (raveConfigDir.exists()) {
                    File[] files = raveConfigDir.listFiles(new XMLFileFilter(false));
                    int x = 0;
                    while (x < files.length) {
                        if (!files[x].isDirectory()) {
                            foundFile = true;
                            this.loadConfiguration(files[x], contexts);
                        }
                        ++x;
                    }
                    if (!foundFile) {
                        this.fFeedback.warn("No config files found within profile dir supplied: " + dataSourceProfileDir);
                    }
                } else {
                    this.fFeedback.warn("Data source profile dir supplied does not exist: " + dataSourceProfileDir);
                }
            }
            if (dataSourceProfileFileName != null) {
                File raveConfigFile = new File(dataSourceProfileFileName);
                if (!raveConfigFile.exists()) {
                    this.fFeedback.warn("Config file specified (" + dataSourceProfileFileName + ") does not exist!");
                } else {
                    boolean loadSingleProfile;
                    if (dataSourceProfileDir != null) {
                        if (raveConfigDir == null || !raveConfigDir.exists()) {
                            loadSingleProfile = true;
                        } else {
                            String dirPath = raveConfigDir.getCanonicalPath();
                            String fileParentPath = RaveAgent.getConfigFileDirectoryName(raveConfigFile);
                            if (this.fFeedback.isDebugEnabled()) {
                                this.fFeedback.debug("dirPath: " + dirPath + "\t fileParentPath: " + fileParentPath);
                            }
                            loadSingleProfile = !dirPath.equals(fileParentPath);
                        }
                    } else {
                        loadSingleProfile = true;
                    }
                    if (loadSingleProfile) {
                        this.loadConfiguration(raveConfigFile, contexts);
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            this.fFeedback.error("Error reading Change detector config file: " + e.getMessage());
        }
        if (foundFile) {
            return true;
        }
        this.fFeedback.info("No datasources available, only EPA collections will run.");
        return false;
    }

    private static final String getConfigFileDirectoryName(File raveConfigFile) throws Exception {
        File configFileParentDir = raveConfigFile.getParentFile();
        String fileParentPath = configFileParentDir != null ? configFileParentDir.getCanonicalPath() : "";
        return fileParentPath;
    }

    private void createNecessaryDirectories() {
        try {
            this.fTmpDirName = RaveUtil.checkCreateMandatoryDirectory(String.valueOf(this.fRaveConfig.getRaveRootDirName()) + TMP_DIR_NAME, this.fFeedback);
            this.fDataDirName = RaveUtil.checkCreateMandatoryDirectory(String.valueOf(this.fRaveConfig.getRaveRootDirName()) + DATA_DIR_NAME, this.fFeedback);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean doEPAgentRegistration() {
        try {
            Class<?> epagentClass = Class.forName("com.wily.introscope.epagent.EPAgent");
            Method regMethod = epagentClass.getDeclaredMethod("registerXMLDataHandler", String.class, IXMLHandler.class);
            regMethod.invoke(null, RAVE_XML_HANDLER_TAG, new EPADataSourceContainer(this.fListenerContainer, this.fFeedback, this.fRaveConfig, this.fHeartbeat));
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fFeedback.debug("ChangeDetector not running within an EPA Agent!");
            return false;
        }
        catch (SecurityException e) {
            String errMsg = "Failed registering ChangeDetector with EPA Agent";
            this.fFeedback.error(errMsg, e);
            throw new RuntimeException(String.valueOf(errMsg) + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            String errMsg = "Failed registering ChangeDetector with EPA Agent";
            this.fFeedback.error(errMsg, e);
            throw new RuntimeException(String.valueOf(errMsg) + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            String errMsg = "Failed registering ChangeDetector with EPA Agent";
            this.fFeedback.error(errMsg, e);
            throw new RuntimeException(String.valueOf(errMsg) + e.getMessage());
        }
        catch (IllegalAccessException e) {
            String errMsg = "Failed registering ChangeDetector with EPA Agent";
            this.fFeedback.error(errMsg, e);
            throw new RuntimeException(String.valueOf(errMsg) + e.getMessage());
        }
        catch (InvocationTargetException e) {
            String errMsg = "Failed registering ChangeDetector with EPA Agent";
            this.fFeedback.error(errMsg, e);
            throw new RuntimeException(String.valueOf(errMsg) + e.getMessage());
        }
    }

    private final void checkWaitInitialization() {
        if (this.fInitThread != null && this.fInitThread.get() != null) {
            return;
        }
        while (true) {
            try {
                this.fInitialized.acquire();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.fFeedback.trace("Ignore interruption exception!");
                continue;
            }
            break;
        }
    }

    public ITaskId addRaveTask(IRaveTask task, Schedule schedule) {
        this.checkWaitInitialization();
        return new RaveTaskExecutor(this, this.fFeedback, task, schedule, this.fHeartbeat);
    }

    public void rmRaveTask(ITaskId taskId) {
        if (!this.fKillRave) {
            ((RaveTaskExecutor)taskId).stopTask();
        }
    }

    protected void loadConfiguration(File raveConfigFile) {
        this.loadConfiguration(raveConfigFile, new HashSet());
    }

    private final void loadConfiguration(File raveConfigFile, HashSet existingContexts) {
        if (this.parser == null) {
            this.parser = new ConfigFileParser(this.fListenerContainer, this.fRaveConfig, existingContexts, this.fCoreAgent, this.fFeedback, this.fLocalizer);
        } else {
            this.parser.resetParser(existingContexts);
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(raveConfigFile);
                this.parser.parse(fis);
            }
            catch (FileNotFoundException e) {
                String errorMsg = "Failed loading Rave configuration!";
                this.fFeedback.error(errorMsg, e);
                throw new RuntimeException(String.valueOf(errorMsg) + e.getMessage());
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    this.fFeedback.warn("Failed closing stream!", ioe);
                }
            }
        }
        if (this.parser.configNeedsUpdating()) {
            boolean doWriting = true;
            boolean doUpdating = this.parser.configHasElementsThatNeedOnlyUpdating();
            if (this.parser.configNeedsOverriding()) {
                doWriting = this.writeConfigFile(raveConfigFile, true);
            }
            if (doWriting && doUpdating) {
                this.writeConfigFile(raveConfigFile, false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean writeConfigFile(File raveConfigFile, boolean deleteBackup) {
        fos = null;
        backupFile = null;
        try {
            updatedConfigFile = new File(raveConfigFile.getAbsolutePath());
            try {
                backupFile = this.backupFile(updatedConfigFile);
                raveConfigFile.renameTo(backupFile);
                ** GOTO lbl29
            }
            catch (SecurityException se) {
                if (deleteBackup) {
                    errorMsg = "Config file needs to be overwritten, but file permissions do not allow it!  Please update permissions and try again!";
                    this.fFeedback.warn(errorMsg);
                    this.fFeedback.verbose("", se);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            this.fFeedback.warn("Failed closing stream!", ioe);
                        }
                    }
                    return false;
                }
                try {
                    backupFile = raveConfigFile;
                    updatedConfigFile = File.createTempFile(raveConfigFile.getName(), ".tmp");
                    errorMsg = "Config file needs updating, but file permissions do not allow it! Writing updated config file to temp file: " + updatedConfigFile.getAbsolutePath();
                    this.fFeedback.warn(errorMsg);
                    this.fFeedback.debug("", se);
lbl29:
                    // 2 sources

                    fos = new FileOutputStream(updatedConfigFile);
                    if (deleteBackup) {
                        this.parser.overrideDocument(fos);
                    } else {
                        this.parser.updateDocument(fos);
                    }
                    if (deleteBackup && backupFile != null && backupFile.exists()) {
                        backupFile.delete();
                    }
                }
                catch (IOException ioe) {
                    errorMsg = "Error while updating configuration file!";
                    this.fFeedback.warn(errorMsg);
                    this.fFeedback.debug(ioe);
                    if (backupFile != null) {
                        if (raveConfigFile.exists()) {
                            raveConfigFile.delete();
                        }
                        backupFile.renameTo(raveConfigFile);
                    }
                    return false;
                }
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    this.fFeedback.warn("Failed closing stream!", ioe);
                }
            }
        }
        return true;
    }

    private File backupFile(File originalFile) throws SecurityException {
        File backupFile = new File(String.valueOf(originalFile.getAbsolutePath()) + ".bak");
        if (backupFile.exists()) {
            NumberFormat format = NumberFormat.getInstance();
            format.setMinimumIntegerDigits(4);
            format.setGroupingUsed(false);
            int count = 1;
            File newBackupFile = new File(String.valueOf(backupFile.getAbsolutePath()) + "." + format.format(count));
            while (newBackupFile.exists()) {
                newBackupFile = new File(String.valueOf(backupFile.getAbsolutePath()) + "." + format.format(++count));
            }
            while (count > 1) {
                File toMoveFile = new File(String.valueOf(backupFile.getAbsolutePath()) + "." + format.format(count - 1));
                toMoveFile.renameTo(new File(String.valueOf(backupFile.getAbsolutePath()) + "." + format.format(count)));
                --count;
            }
            File toMove = new File(backupFile.getAbsolutePath());
            toMove.renameTo(new File(String.valueOf(backupFile.getAbsolutePath()) + "." + format.format(1L)));
        }
        return backupFile;
    }

    String getDataSourceProfileFileName() {
        this.checkWaitInitialization();
        return this.fRaveConfig.getDataSourceProfileFileName();
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    private final void feedbackStartupMessage() {
        String releaseStr = this.fLocalizer.IStringLocalizer_getLocalizedString("Release_String_Key");
        String buildStr = this.fLocalizer.IStringLocalizer_getLocalizedString("Build_Number_String_Key");
        String releaseAndBuild = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("FormattedChangeDetectorReleaseAndBuildString", releaseStr, buildStr);
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("FormattedProductNameAndReleaseAndBuildString", this.fLocalizer.IStringLocalizer_getLocalizedString("Rave_Agent_Printable_Name"), releaseAndBuild));
    }

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public boolean shouldSendData() {
        IsengardServerConnectionManager manager = this.fCoreAgent.IAgent_getIsengardServerConnection();
        if (manager != null) {
            return manager.shouldSendData();
        }
        return false;
    }

    public String getDataDir() {
        this.checkWaitInitialization();
        return this.fDataDirName;
    }

    public String getTmpDir() {
        this.checkWaitInitialization();
        return this.fTmpDirName;
    }

    public synchronized String getName() {
        this.checkWaitInitialization();
        return this.fRaveConfig.getRaveAgentID();
    }

    public boolean raveShuttingDown() {
        return this.fKillRave;
    }

    public synchronized void shutDown() {
        if (this.fKillRave) {
            return;
        }
        this.fKillRave = true;
        this.fFeedback.warn("Shutting down ChangeDetector agent extension...");
        if (this.fHeartbeat != null) {
            this.fHeartbeat.tearDownIntervalHeartbeat();
        }
        if (this.fCompressionHeartbeat != null) {
            this.fCompressionHeartbeat.tearDownIntervalHeartbeat();
        }
        if (this.fConnectionManager != null) {
            this.fConnectionManager.destroy();
        }
        if (this.fAgentNameMappingHandler != null) {
            this.fAgentNameMappingHandler.destroy();
        }
        this.fFeedback.warn("Successfully shut down ChangeDetector agent extension.");
    }

    public IWatchedAgent getWatchedAgentBean() {
        this.checkWaitInitialization();
        return this.fConnectionManager.getWatchedAgentBean();
    }

    public void stopAgentNameMappingNotification(int reqId) {
        this.checkWaitInitialization();
        this.fAgentNameMappingHandler.stopAgentNameMappingNotification(reqId);
    }

    public void startAgentNameMappingNotification() {
        this.checkWaitInitialization();
        this.fAgentNameMappingHandler.startAgentNameMappingNotification();
    }

    protected RaveConfiguration getRaveConfig() {
        return this.fRaveConfig;
    }

    public boolean staleWatchedAgent(IWatchedAgent watchedAgent) {
        return this.fConnectionManager.staleWatchedAgentBean(watchedAgent);
    }

    private static final class CompressEntriesBatchSizeConfigurationProperty
    extends PositiveIntegerConfigurationProperty {
        private CompressEntriesBatchSizeConfigurationProperty(IAgent agent) {
            super(RaveAgent.kBatchProperty, kDefaultBatchSize, agent.IAgent_getModuleFeedback(), changeDetectorModule, agent.IAgent_getStringLocalizer());
        }
    }

    private static final class CompressEntriesConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private CompressEntriesConfigurationProperty(IAgent agent) {
            super(RaveAgent.kCompressProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), changeDetectorModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        @Override
        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }
}

