/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.isengard.IsengardException;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.rave.agent.AgentBeanParamContainer;
import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.api.IRaveAgentService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RaveAgentBean
extends AIsengardBean
implements IRaveAgentService {
    private RaveAgent fRaveAgent;
    private IModuleFeedbackChannel fFeedback;

    public void activate() throws IsengardException {
        try {
            this.fRaveAgent = ((AgentBeanParamContainer)this.getBeanDescriptor().getInstanceData()).rageAgent;
            this.fFeedback = this.fRaveAgent.getFeedback();
            this.getFeedback().info(this.getModule(), "Initializing ChangeDetector Agent Service");
            this.createMessageService(IRaveAgentService.class, String.valueOf(IRaveAgentService.SERVICE_PREFIX) + this.fRaveAgent.getName(), null);
            this.getFeedback().info(this.getModule(), "Finished Initializing ChangeDetector Agent Service");
        }
        catch (ConnectionException ex) {
            throw ex;
        }
        catch (EntryAlreadyExistsException ex) {
            this.getFeedback().error(this.getModule(), "Error activating ChangeDetector Service.  This was caused by another ChangeDetector Agent having the same ChangeDetector ID.", ex);
            throw ex;
        }
        catch (Exception e) {
            this.getFeedbackChannel().error(this.getModule(), "Error initializing ChangeDetector Agent Service!", e);
            throw new BeanActivationException(this.getBeanDescriptor(), (Throwable)e);
        }
    }

    public synchronized byte[] getRaveConfig() {
        File config = new File(this.fRaveAgent.getDataSourceProfileFileName());
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(config));
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
            int size = inputStream.read(buffer);
            do {
                outputBuffer.write(buffer, 0, size);
            } while (size == 1024);
            System.out.println(new String(outputBuffer.toByteArray(), "UTF8"));
            byte[] byArray = outputBuffer.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            this.getFeedback().error("Failed loading file!", e);
            throw new RuntimeException("Failed loading file." + e.getMessage());
        }
        catch (IOException e) {
            this.getFeedback().error("Failed loading file!", e);
            throw new RuntimeException("Failed loading file." + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.getFeedback().error("Failed closing file!", e);
                    throw new RuntimeException("Failed closing file." + e.getMessage());
                }
            }
        }
    }

    public synchronized void setRaveConfig(byte[] newContent) {
        File config = new File(this.fRaveAgent.getDataSourceProfileFileName());
        File tmpFile = new File(String.valueOf(config.getAbsolutePath()) + ".tmp");
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(tmpFile));
                outputStream.write(newContent);
                outputStream.close();
                tmpFile.renameTo(config);
            }
            catch (FileNotFoundException e) {
                this.getFeedback().error("Failed loading file!", e);
                throw new RuntimeException("Failed loading file." + e.getMessage());
            }
            catch (IOException e) {
                this.getFeedback().error("Failed while generating new file!", e);
                throw new RuntimeException("Failed while generating new file." + e.getMessage());
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.getFeedback().error("Failed closing file!", e);
                    throw new RuntimeException("Failed closing file." + e.getMessage());
                }
            }
        }
    }

    public void stopAgentNameMappingNotification(int reqId) {
        this.fRaveAgent.stopAgentNameMappingNotification(reqId);
    }

    private final IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }
}

