/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;

class RaveAgentNameMappingHandler
implements INameChangeListener {
    private static final long MAPPING_NOTIF_PERIOD = 15000L;
    private static final String AGENT_MAPPING_BEHAVIOR_NAME = "Rave agent id mapping notification";
    private int agentNameMappingNotifReqId;
    private IntervalHeartbeat heartbeat;
    private IAgent agent;
    private String raveAgentName;
    private IRegisteredBehavior agentNameMappingNotifBehav;
    private IModuleFeedbackChannel feedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RaveAgentNameMappingHandler(IAgent agent, IntervalHeartbeat heartbeat, IModuleFeedbackChannel feedback, String raveAgentName) {
        RaveAgentNameMappingHandler raveAgentNameMappingHandler = this;
        synchronized (raveAgentNameMappingHandler) {
            this.agentNameMappingNotifReqId = 0;
            this.heartbeat = heartbeat;
            this.agent = agent;
            this.feedback = feedback;
            this.raveAgentName = raveAgentName;
            agent.IAgent_addNameChangeListener((INameChangeListener)this);
        }
    }

    @Override
    public synchronized void INameChangeListener_nameChanged(String newName) {
        this.feedback.debug("Introscope agent name changed to: " + newName);
        this.startAgentNameMappingNotification();
    }

    synchronized void destroy() {
        this.agent.IAgent_removeNameChangeListener((INameChangeListener)this);
    }

    synchronized void startAgentNameMappingNotification() {
        int n;
        if (this.agentNameMappingNotifReqId == Integer.MAX_VALUE) {
            n = 0;
        } else {
            int n2 = this.agentNameMappingNotifReqId;
            n = n2;
            this.agentNameMappingNotifReqId = n2 + 1;
        }
        this.agentNameMappingNotifReqId = n;
        if (this.agentNameMappingNotifBehav == null) {
            this.agentNameMappingNotifBehav = this.heartbeat.addBehavior(this.createAgentNameMappingNotifBehav(), AGENT_MAPPING_BEHAVIOR_NAME, true, 15000L, true);
        }
    }

    synchronized void stopAgentNameMappingNotification(int reqId) {
        if (this.agentNameMappingNotifBehav != null) {
            if (this.agentNameMappingNotifReqId == reqId) {
                this.heartbeat.removeBehavior(this.agentNameMappingNotifBehav);
                this.agentNameMappingNotifBehav = null;
            } else {
                this.feedback.info("Ignoring request to stop ChangeDetector id notif svc. [" + reqId + "/" + this.agentNameMappingNotifReqId + "]");
            }
        } else {
            this.feedback.info("Ignoring request to stop ChangeDetector id notif svc, as this is not running!");
        }
    }

    private synchronized void sendMetricValue(int counter) {
        try {
            IStringEveryEventDataAccumulator fDataAccum = this.agent.IAgent_getDataAccumulatorFactory().getStringEveryEventDataAccumulator("ChangeDetector.AgentID");
            fDataAccum.IStringEveryEventDataAccumulator_addString(String.valueOf(this.raveAgentName) + "|" + this.agentNameMappingNotifReqId + "|" + counter);
        }
        catch (BadlyFormedNameException e) {
            this.feedback.error("Failed sending metric with rave agent Id.", e);
        }
        catch (ConflictingTypesException e) {
            this.feedback.error("Failed sending metric with rave agent Id.", e);
        }
    }

    private ITimestampedRunnable createAgentNameMappingNotifBehav() {
        return new ITimestampedRunnable(){
            private int counter = 0;

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                ++this.counter;
                this.counter %= Integer.MAX_VALUE;
                RaveAgentNameMappingHandler.this.sendMetricValue(this.counter);
            }
        };
    }
}

