/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.config.parser;

import com.wily.rave.agent.config.ConfigException;
import com.wily.util.PropertyNotFoundException;
import com.wily.util.PropertySubstitutionStringParser;
import com.wily.util.properties.IndexedProperties;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ElementParserHelper {
    private static final Object kLockingObject = new Object();
    private static IndexedProperties agentProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setAgentProps(IndexedProperties props) {
        Object object = kLockingObject;
        synchronized (object) {
            agentProps = props;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IndexedProperties getAgentProps() {
        Object object = kLockingObject;
        synchronized (object) {
            return agentProps;
        }
    }

    public static final String getRequiredAttribute(Element element, String attributeName) throws ConfigException {
        return ElementParserHelper.getRequiredAttribute(element, attributeName, true);
    }

    public static final String getRequiredAttribute(Element element, String attributeName, boolean substituteProperties) throws ConfigException {
        String val = ElementParserHelper.getOptionalAttribute(element, attributeName, substituteProperties);
        if (val == null) {
            throw new ConfigException("Missing Required Attribute: " + attributeName);
        }
        return val;
    }

    public static final String getAttribute(Element element, String attributeName, String defaultValue) throws ConfigException {
        return ElementParserHelper.getAttribute(element, attributeName, defaultValue, true);
    }

    public static final String getAttribute(Element element, String attributeName, String defaultValue, boolean substituteProperties) throws ConfigException {
        String val = ElementParserHelper.getOptionalAttribute(element, attributeName, substituteProperties);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public static final String getOptionalAttribute(Element element, String attributeName) throws ConfigException {
        return ElementParserHelper.getOptionalAttribute(element, attributeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getOptionalAttribute(Element element, String attributeName, boolean substituteProperties) throws ConfigException {
        Object object = kLockingObject;
        synchronized (object) {
            Attr attribute;
            block7: {
                attribute = element.getAttributeNode(attributeName);
                if (attribute != null) break block7;
                return null;
            }
            if (substituteProperties) {
                PropertySubstitutionStringParser parser;
                try {
                    parser = new PropertySubstitutionStringParser(attribute.getValue(), agentProps);
                }
                catch (PropertyNotFoundException e) {
                    throw new ConfigException("Property not found: " + e.getPropertyName());
                }
                return parser.getPropertySubstitutedString();
            }
            return attribute.getValue();
        }
    }

    private static final boolean parseBooleanValue(String attribute, String value) throws ConfigException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ConfigException("Non boolean value in boolean attribute '" + attribute + "'; Value: " + value);
    }

    public static final boolean getBooleanAttribute(Element element, String attributeName, boolean defaultValue) throws ConfigException {
        return ElementParserHelper.getBooleanAttribute(element, attributeName, defaultValue, true);
    }

    public static final boolean getBooleanAttribute(Element element, String attributeName, boolean defaultValue, boolean substituteProperties) throws ConfigException {
        String attribute = ElementParserHelper.getOptionalAttribute(element, attributeName, substituteProperties);
        if (attribute == null) {
            return defaultValue;
        }
        return ElementParserHelper.parseBooleanValue(attributeName, attribute);
    }

    public static final boolean getBooleanAttribute(Element element, String attributeName) throws ConfigException {
        String attribute = ElementParserHelper.getRequiredAttribute(element, attributeName);
        return ElementParserHelper.parseBooleanValue(attributeName, attribute);
    }

    public static final int getRequiredIntegerAttribute(Element element, String attributeName) throws ConfigException {
        String attribute = ElementParserHelper.getRequiredAttribute(element, attributeName);
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException("Invalid numeric attribute '" + attributeName + "'. Value: " + attribute);
        }
    }

    public static final int getOptionalIntegerAttribute(Element element, String attributeName, int defaultValue) throws ConfigException {
        String attribute = ElementParserHelper.getOptionalAttribute(element, attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException("Invalid numeric attribute '" + attributeName + "'. Value: " + attribute);
        }
    }
}

