/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds;

import com.wily.rave.agent.cache.IRaveContentCache;
import com.wily.rave.agent.ds.AgentPropertyChangeEvent;
import com.wily.rave.agent.ds.IDataSource;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.DataSourceRuntimeException;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class ASimpleDataSource
implements IDataSource {
    private List contentList;
    private List prevContentList;
    private IDataSourceListener listener;

    protected ASimpleDataSource() {
    }

    protected void init(IDataSourceListener listener) {
        this.listener = listener;
        this.contentList = new ArrayList();
        this.prevContentList = new ArrayList(listener.getCache().keySet().size());
        Iterator iter = listener.getCache().keySet().iterator();
        while (iter.hasNext()) {
            this.prevContentList.add(iter.next());
        }
    }

    protected final IModuleFeedbackChannel getFeedback() {
        return this.listener.getFeedback();
    }

    protected final void handContent(String resourceName, String resourceValue) throws RestartScanException {
        int index = Collections.binarySearch(this.contentList, resourceName);
        if (index >= 0) {
            throw new DataSourceRuntimeException("Reporting the same resource name in the same scan is not supported. Duplicate data point: " + resourceName);
        }
        IRaveContentCache cache = this.listener.getCache();
        Serializable cachedContent = cache.get((Serializable)((Object)resourceName));
        try {
            if (cachedContent == null) {
                this.listener.contentChangeEvent(AgentPropertyChangeEvent.getAgentPropertyAdditionEvent(resourceName, resourceValue, this.listener.getDSInstance(), new Date().getTime()));
            } else if (!cachedContent.equals(resourceValue)) {
                this.listener.contentChangeEvent(AgentPropertyChangeEvent.getAgentPropertyModificationEvent(resourceName, resourceValue, this.listener.getDSInstance(), new Date().getTime()));
            }
        }
        catch (RestartCollectionException e) {
            this.restartCollection();
            throw new RestartScanException(e.getMessage());
        }
        this.contentList.add(-index - 1, resourceName);
    }

    protected final void reportEndOfScan() throws RestartScanException {
        this.prevContentList.removeAll(this.contentList);
        try {
            for (String resourceName : this.prevContentList) {
                this.listener.contentChangeEvent(AgentPropertyChangeEvent.getAgentPropertyDeletionEvent(resourceName, this.listener.getDSInstance(), System.currentTimeMillis()));
            }
            this.listener.endOfScan();
        }
        catch (RestartCollectionException e) {
            this.restartCollection();
            throw new RestartScanException(e.getMessage());
        }
        this.prevContentList = this.contentList;
        this.contentList = new ArrayList();
    }

    public final void requestScanRestart() throws RestartScanException {
        try {
            this.listener.requestScanRestart();
        }
        catch (RestartCollectionException ex) {
            this.restartCollection();
            throw new RestartScanException(ex.getMessage());
        }
    }

    public final void restartScan() {
        this.contentList.clear();
        this.listener.restartScan();
    }

    public final void restartCollection() {
        this.contentList.clear();
        this.listener.restartCollection();
    }

    public String getTaskName() {
        return "Main collection for " + this.getClass().getName() + "; Instance: " + this.listener.getDSInstance();
    }

    protected final IDataSourceInstance getDSInstance() {
        return this.listener.getDSInstance();
    }
}

