/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashMap;

class ClassSpec
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static HashMap classSpecs = new HashMap();
    protected String className;
    protected String packageName;
    protected ClassSpec classloaderSpec;
    protected String assemblyPath;
    protected String assemblyVersion;

    public ClassSpec() {
    }

    protected ClassSpec(String className, ClassLoader loader) {
        int classNameSeparatorIdx = className.lastIndexOf(46);
        if (classNameSeparatorIdx != -1) {
            this.className = className.substring(classNameSeparatorIdx + 1).intern();
            this.packageName = className.substring(0, classNameSeparatorIdx).intern();
        } else {
            this.className = className;
            this.packageName = "".intern();
        }
        this.classloaderSpec = loader == null ? null : ClassSpec.getClassSpec(loader.getClass().getName(), loader.getClass().getClassLoader());
    }

    public static final ClassSpec getClassSpec(String className, ClassLoader classLoader) {
        ClassSpec cSpecCp = new ClassSpec(className, classLoader);
        return ClassSpec.getClassSpec(cSpecCp);
    }

    public static final ClassSpec getClassSpec(String assemblyPath, String version, String className, ClassLoader classLoader) {
        ClassSpec cSpecCp = new ClassSpec(className, classLoader);
        cSpecCp.assemblyPath = assemblyPath;
        cSpecCp.assemblyVersion = version;
        return ClassSpec.getClassSpec(cSpecCp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClassSpec getClassSpec(ClassSpec cSpecCp) {
        HashMap hashMap = classSpecs;
        synchronized (hashMap) {
            ClassSpec cSpec = (ClassSpec)classSpecs.get(cSpecCp);
            if (cSpec != null) {
                return cSpec;
            }
            classSpecs.put(cSpecCp, cSpecCp);
        }
        return cSpecCp;
    }

    public String getFullName() {
        return this.getFullName(0);
    }

    public String getFullName(int instanceId) {
        return ClassSpec.getFullName(new StringBuffer(), this, instanceId).toString();
    }

    private static StringBuffer getFullName(StringBuffer buffer, ClassSpec cSpec, int instanceId) {
        buffer.append(cSpec.packageName).append('.').append(cSpec.className);
        if (instanceId != 0) {
            buffer.append(":").append(instanceId);
        }
        if (cSpec.classloaderSpec != null) {
            ClassSpec.getFullName(buffer.append(" ["), cSpec.classloaderSpec, 0).append("] ");
        }
        return buffer;
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode((int)this.packageName.hashCode(), (Object)this.className);
        if (this.classloaderSpec != null) {
            code = HashCodeUtils.accumulateHashCode((int)code, (int)this.classloaderSpec.hashCode());
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ClassSpec) {
            ClassSpec otherSpec = (ClassSpec)other;
            if (otherSpec.className.equals(this.className) && otherSpec.packageName.equals(this.packageName)) {
                if (this.classloaderSpec == null) {
                    return otherSpec.classloaderSpec == null;
                }
                return this.classloaderSpec.equals(otherSpec.classloaderSpec);
            }
        }
        return false;
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + this.getFullName();
        return this.getFullName();
    }

    private Object readResolve() throws ObjectStreamException {
        return ClassSpec.getClassSpec(this);
    }

    public String getAssemblyPath() {
        return this.assemblyPath;
    }

    public String getAssemblyVersion() {
        return this.assemblyVersion;
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.packageName = oi.readUTF();
        this.className = oi.readUTF();
        classSpecs = (HashMap)oi.readObject();
        this.classloaderSpec = (ClassSpec)oi.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.packageName);
        oo.writeUTF(this.className);
        oo.writeObject(classSpecs);
        oo.writeObject(this.classloaderSpec);
    }
}

