/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.db;

import com.wily.rave.agent.ds.ASimplePolledDataSource;
import com.wily.rave.agent.ds.exception.DataSourceRuntimeException;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class DBDataSource
extends ASimplePolledDataSource {
    private static final String DB_DATA_SOURCE_TYPE = "Database Monitor";
    private String fDriver;
    private String fUrl;
    private String fUsername;
    private String fPassword;
    private String[] fQueries;
    private boolean driverLoaded;
    private boolean requestedRestart;

    public DBDataSource(String driver, String url, String username, String password, String[] queries) {
        this.fDriver = driver;
        this.fUrl = url;
        this.fUsername = username;
        this.fPassword = password;
        this.fQueries = queries;
        this.driverLoaded = false;
        this.requestedRestart = false;
    }

    @Override
    protected void init() {
    }

    public String toString() {
        return String.valueOf(this.fDriver) + "; " + this.fUrl + "; " + this.fUsername + "; " + this.fPassword;
    }

    @Override
    public void collect() throws RestartCollectionException, RestartScanException {
        block25: {
            if (this.requestedRestart) {
                this.requestedRestart = false;
                return;
            }
            Connection conn = null;
            String query = "";
            try {
                try {
                    conn = this.getConnection();
                    boolean debug = this.getFeedback().isDebugEnabled();
                    int i = 0;
                    while (i < this.fQueries.length) {
                        Statement stmt = null;
                        ResultSet resultSet = null;
                        try {
                            query = this.fQueries[i];
                            stmt = conn.createStatement();
                            stmt.execute(query);
                            resultSet = stmt.getResultSet();
                            while (resultSet.next()) {
                                String name = resultSet.getString(1);
                                String value = resultSet.getString(2);
                                if (name == null) {
                                    this.getFeedback().error("Resource name from result set was null! This is unsupported, so stopping collection!");
                                    throw new StopCollectionException("Resource name from result set was null!  This is unsupported.  Stopping collection!");
                                }
                                String string = value = value == null ? "<null>" : value;
                                if (debug) {
                                    this.getFeedback().debug("Name: " + name + "; Value: " + value);
                                }
                                this.handContent(name, value);
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        ++i;
                    }
                    this.reportEndOfScan();
                }
                catch (SQLException e) {
                    this.getFeedback().error("Error collecting data for context '" + this.getDSInstance() + "'");
                    this.getFeedback().error("Could not collect data for SQL: " + query);
                    this.getFeedback().error(e);
                    this.requestedRestart = true;
                    this.requestScanRestart();
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {
                            this.getFeedback().error("Failed closing connection for context '" + this.getDSInstance() + "'");
                        }
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        this.getFeedback().error("Failed closing connection for context '" + this.getDSInstance() + "'");
                    }
                }
                throw throwable;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    this.getFeedback().error("Failed closing connection for context '" + this.getDSInstance() + "'");
                }
            }
        }
    }

    private Connection getConnection() throws SQLException {
        if (!this.driverLoaded) {
            try {
                Class.forName(this.fDriver);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DataSourceRuntimeException("Couldn't find JDBC driver [" + this.fDriver + "]");
            }
            this.driverLoaded = true;
        }
        Connection conn = null;
        conn = this.fUsername == null && this.fPassword == null ? DriverManager.getConnection(this.fUrl) : DriverManager.getConnection(this.fUrl, this.fUsername, this.fPassword);
        return conn;
    }

    public void reset() {
    }

    public String getDataSourceName() {
        return DB_DATA_SOURCE_TYPE;
    }

    @Override
    public void stop() {
    }
}

