/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.db;

import com.wily.introscope.agent.IAgent;
import com.wily.rave.agent.config.ADataSourceConfig;
import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.IUpdatingDataSourceConfig;
import com.wily.rave.agent.config.parser.ConfigFileParser;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.config.parser.ScheduleParser;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.db.DBDataSource;
import com.wily.rave.agent.task.Schedule;
import com.wily.rave.utils.Utilities;
import com.wily.util.PropertyNotFoundException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.obfuscation.SimpleDecryptor;
import com.wily.util.obfuscation.SimpleEncryptor;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DBDataSourceConfig
extends ADataSourceConfig
implements IUpdatingDataSourceConfig {
    private Schedule fSchedule;
    protected String fDriver;
    protected String fConnectionURL;
    protected String fUsername;
    protected String fPassword;
    private String fDriverClassPath;
    protected List fQueries = new LinkedList();
    protected boolean shouldExistingElementBeBackedUp = true;
    protected Element updatedXMLElement;

    @Override
    public IPolledDataSource parseConfig(Element dataSourceRoot, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws ConfigException {
        this.doParse(dataSourceRoot);
        try {
            String[] urlStrings = ConfigFileParser.getDriverURLStrings(this.fDriverClassPath);
            URL[] urls = ConfigFileParser.getURLFromStrings(urlStrings);
            DBDataSourceClassloader loader = new DBDataSourceClassloader(urls, DBDataSource.class.getClassLoader(), feedback);
            Class<?> clz = Class.forName(DBDataSource.class.getName(), true, loader);
            Constructor<?> constructor = clz.getConstructor(String.class, String.class, String.class, String.class, String[].class);
            String[] queries = this.fQueries.toArray(new String[this.fQueries.size()]);
            IPolledDataSource dataSource = (IPolledDataSource)constructor.newInstance(this.fDriver, this.fConnectionURL, this.fUsername, this.fPassword, queries);
            return dataSource;
        }
        catch (PropertyNotFoundException pnfe) {
            feedback.error("Failed creating DB Data Source!", pnfe);
            throw new ConfigException(pnfe.getMessage());
        }
        catch (MalformedURLException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (SecurityException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (InstantiationException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            feedback.error("Failed creating DB Data Source!", e);
            throw new ConfigException(e.getMessage());
        }
    }

    @Override
    public Schedule getMainTaskSchedule() {
        return this.fSchedule;
    }

    protected void doParse(Element dataSourceRoot) throws ConfigException {
        Element clonedElement;
        this.updatedXMLElement = null;
        String version = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "version");
        if (version == null) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (version.equals("7.1")) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (!version.equals("8.0")) {
            throw new ConfigException("Unknown DB DataSource Config Version: " + version);
        }
        this.fDriver = ElementParserHelper.getRequiredAttribute(dataSourceRoot, "driver");
        this.fConnectionURL = ElementParserHelper.getRequiredAttribute(dataSourceRoot, "url");
        int key = 3939834;
        SimpleEncryptor encryptor = new SimpleEncryptor(key);
        SimpleDecryptor decryptor = new SimpleDecryptor(key);
        this.fUsername = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "username");
        this.fPassword = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "password");
        if (this.fUsername != null && this.fPassword != null) {
            byte[] passwordBytes;
            byte[] userNameBytes;
            String isClearTextString = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "isClearText");
            boolean pwNeedsUpdating = false;
            if (isClearTextString == null) {
                pwNeedsUpdating = true;
            } else if (!isClearTextString.equalsIgnoreCase("false")) {
                pwNeedsUpdating = true;
            } else {
                try {
                    if (this.fUsername != null) {
                        userNameBytes = DBDataSourceConfig.decodeHex(this.fUsername);
                        decryptor.transformInPlace(userNameBytes);
                        this.fUsername = new String(userNameBytes);
                    }
                    if (this.fPassword != null) {
                        passwordBytes = DBDataSourceConfig.decodeHex(this.fPassword);
                        decryptor.transformInPlace(passwordBytes);
                        this.fPassword = new String(passwordBytes);
                    }
                }
                catch (Exception e) {
                    throw new ConfigException("Error while decrypting stored username and password!\n" + e.getMessage());
                }
            }
            if (pwNeedsUpdating) {
                this.shouldExistingElementBeBackedUp = false;
                if (this.updatedXMLElement == null) {
                    Element clonedElement2;
                    this.updatedXMLElement = clonedElement2 = (Element)dataSourceRoot.cloneNode(true);
                }
                this.updatedXMLElement.setAttribute("isClearText", "false");
                if (this.fUsername != null) {
                    userNameBytes = this.fUsername.getBytes();
                    encryptor.transformInPlace(userNameBytes);
                    String userNameHexString = DBDataSourceConfig.encodeHex(userNameBytes);
                    this.updatedXMLElement.setAttribute("username", userNameHexString);
                }
                if (this.fPassword != null) {
                    passwordBytes = this.fPassword.getBytes();
                    encryptor.transformInPlace(passwordBytes);
                    String passwordHexString = DBDataSourceConfig.encodeHex(passwordBytes);
                    this.updatedXMLElement.setAttribute("password", passwordHexString);
                }
            }
        } else if (this.fUsername == null && this.fPassword != null || this.fUsername != null && this.fPassword == null) {
            if (this.fUsername == null) {
                throw new ConfigException("username attribute is required if password is supplied for database datasource config!");
            }
            throw new ConfigException("password attribute is required if username is supplied for database datasource config!");
        }
        this.fDriverClassPath = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "driverJar", false);
        if (this.fDriverClassPath == null) {
            this.fDriverClassPath = ElementParserHelper.getRequiredAttribute(dataSourceRoot, "driverClasspath", false);
        } else {
            if (this.updatedXMLElement == null) {
                Element clonedElement3;
                this.updatedXMLElement = clonedElement3 = (Element)dataSourceRoot.cloneNode(true);
            }
            this.updatedXMLElement.removeAttribute("driverJar");
            String fileName = DBDataSourceConfig.replaceEscapeCharacters(this.fDriverClassPath);
            this.updatedXMLElement.setAttribute("driverClasspath", fileName);
        }
        Node child = dataSourceRoot.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                this.parseChild((Element)child);
            }
            child = child.getNextSibling();
        }
    }

    private void parseChild(Element child) throws ConfigException {
        String name = child.getNodeName();
        if (name.equals("sql")) {
            NodeList list = child.getChildNodes();
            int count = list.getLength() - 1;
            while (count >= 0) {
                Node queryElement = list.item(count);
                short nodeType = queryElement.getNodeType();
                if (nodeType == 3 || nodeType == 4) {
                    if (!(queryElement instanceof Text)) {
                        throw new ConfigException("Unexpected or invalid node: " + queryElement.getNodeName());
                    }
                    String query = ((Text)queryElement).getData().trim();
                    if (!query.equals("")) {
                        this.fQueries.add(query);
                        break;
                    }
                } else {
                    throw new ConfigException("Unexpected or invalid node: " + queryElement.getNodeName());
                }
                --count;
            }
        } else if (name.equals("schedule")) {
            this.fSchedule = ScheduleParser.getSchedule(child);
        } else {
            throw new ConfigException("Unexpected or invalid node: " + name);
        }
    }

    @Override
    public String getDataSourceType() {
        return "DBMonitor";
    }

    @Override
    public Element getUpdatedXMLElement() {
        return this.updatedXMLElement;
    }

    @Override
    public boolean shouldExistingElementBeBackedUp() {
        return this.shouldExistingElementBeBackedUp;
    }

    private static String replaceEscapeCharacters(String string) {
        int tempIndex;
        StringBuilder buffer = new StringBuilder();
        int index = 0;
        do {
            if ((tempIndex = string.indexOf(92, index)) == -1) {
                buffer.append(string.substring(index));
                continue;
            }
            buffer.append(string.substring(index, tempIndex));
            buffer.append("\\\\");
            if (tempIndex + 1 >= string.length()) {
                tempIndex = -1;
                continue;
            }
            char testChar = string.charAt(tempIndex + 1);
            if (testChar != '\\') continue;
            tempIndex += 2;
        } while ((index = ++tempIndex) != -1);
        return buffer.toString();
    }

    private static String encodeHex(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    private static byte[] decodeHex(String data) throws Exception {
        return DBDataSourceConfig.decodeHex(data.toCharArray());
    }

    private static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = DBDataSourceConfig.toDigit(data[j], j) << 4;
            f |= DBDataSourceConfig.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    private static class DBDataSourceClassloader
    extends URLClassLoader {
        private IModuleFeedbackChannel feedback;

        private DBDataSourceClassloader(URL[] classPath, ClassLoader parentClassloader, IModuleFeedbackChannel feedback) {
            super(classPath, parentClassloader);
            this.feedback = feedback;
        }

        public synchronized Class loadClass(String name) throws ClassNotFoundException {
            byte[] classBytes;
            if (!name.equals(DBDataSource.class.getName())) {
                return super.loadClass(name);
            }
            try {
                ClassLoader cl = super.getParent();
                String className = name.replace('.', '/').concat(".class");
                classBytes = cl != null ? Utilities.toByteArray((InputStream)cl.getResourceAsStream(className)) : Utilities.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream(className));
            }
            catch (IOException e) {
                this.feedback.error("Failed loading class " + name);
                throw new RuntimeException(e.getMessage());
            }
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
    }
}

