/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.ds.file.DirectoryScanner;
import com.wily.rave.agent.ds.file.FileSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashSet;
import java.util.Set;

public final class DirScannerListener {
    private int numReporters;
    private Set reporters;
    private FileSet nextFileSet;
    private IModuleFeedbackChannel feedback;

    DirScannerListener(int numReporters, IModuleFeedbackChannel feedback) {
        this.numReporters = numReporters;
        this.reporters = new HashSet();
        this.feedback = feedback;
        this.nextFileSet = new FileSet(feedback);
    }

    synchronized FileSet restartListening() {
        if (!this.allReported()) {
            throw new IllegalStateException("Request to start listening while run not complete!");
        }
        this.reporters.clear();
        FileSet processedFileSet = this.nextFileSet;
        this.nextFileSet = new FileSet(this.feedback);
        return processedFileSet;
    }

    synchronized void report(DirectoryScanner reporter, FileSet newFileSet) {
        if (this.reporters.contains(reporter)) {
            throw new RuntimeException("Reporter reported more than once! Reporter: " + reporter);
        }
        this.nextFileSet.addAll(newFileSet);
        this.reporters.add(reporter);
    }

    synchronized boolean allReported() {
        return this.reporters.size() == this.numReporters;
    }
}

