/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.cache.IRaveContentCache;
import com.wily.rave.agent.config.DirectoryScanSpec;
import com.wily.rave.agent.ds.IAgentContentChangeEvent;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.file.AgentFileChangeEvent;
import com.wily.rave.agent.ds.file.ArchiveFileInfoHolder;
import com.wily.rave.agent.ds.file.ArchiveMonitor;
import com.wily.rave.agent.ds.file.DirScannerListener;
import com.wily.rave.agent.ds.file.DirectoryScanner;
import com.wily.rave.agent.ds.file.FileCacheEntry;
import com.wily.rave.agent.ds.file.FileDataSourceConfigProps;
import com.wily.rave.agent.ds.file.FileSet;
import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.AFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.IFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.RealFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.RealFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpec;
import com.wily.rave.agent.ds.task.IDataSourceTask;
import com.wily.rave.spec.ds.filemonitor.ASCIIFileContent;
import com.wily.rave.spec.ds.filemonitor.FileContent;
import com.wily.rave.spec.ds.filemonitor.FileContentValue;
import com.wily.rave.utils.FastMD5Encoder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class FileSystemMonitor
implements IPolledDataSource,
IDataSourceTask {
    private static final String FS_DATA_SOURCE_TYPE = "File System Monitor";
    private static final Iterator EMPTY_ITER = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    protected ArchiveMonitor archiveMonitor;
    protected FileSet curFileSet;
    protected Iterator fileSetIterator;
    private DirScannerListener dirScnannerReporterListener;
    private boolean beforeFirstScan;
    private final FileDataSourceConfigProps dataSourceConfigProps;
    protected List dirScanners;
    private IDataSourceListener listener;
    private List scanDirectories;
    private boolean forceWaitForDirScan;

    public FileSystemMonitor(List scanDirectories, FileDataSourceConfigProps dataSourceConfigProps) {
        this.dataSourceConfigProps = dataSourceConfigProps;
        this.scanDirectories = scanDirectories;
    }

    @Override
    public void init(IDataSourceListener listener) {
        this.listener = listener;
        this.archiveMonitor = ArchiveMonitor.getArchiveMonitor(this);
        this.dirScnannerReporterListener = new DirScannerListener(this.scanDirectories.size(), listener.getFeedback());
        this.dirScanners = new LinkedList();
        Iterator iter = this.scanDirectories.iterator();
        while (iter.hasNext()) {
            this.dirScanners.add(new DirectoryScanner(this, (DirectoryScanSpec)iter.next(), this.dirScnannerReporterListener));
        }
        this.scanDirectories = null;
        this.forceRestart();
        this.schedule();
    }

    @Override
    public void collect() throws RestartCollectionException, RestartScanException {
        int i = this.dataSourceConfigProps.filesPerIteration;
        do {
            if (!this.fileSetIterator.hasNext()) {
                this.handleIteratorOver();
                if (!this.fileSetIterator.hasNext()) {
                    return;
                }
            }
            RealFileSpecRuntime nextFile = new RealFileSpecRuntime((RealFileSpec)this.fileSetIterator.next());
            try {
                this.pollAndReportFileContent(nextFile);
            }
            catch (IOException e) {
                this.getFeedbackChannel().warn("Error tracking change in " + nextFile + ". No data will be reported for this file in this run. If this is an intermittent problem (e.g. file locked) it may be ignored as long as it does not persist.");
                this.getFeedbackChannel().verbose("", e);
            }
        } while (--i > 0);
    }

    private void handleIteratorOver() throws RestartCollectionException, RestartScanException {
        boolean reportEndOfScan = true;
        if (this.forceWaitForDirScan) {
            if (this.dirScnannerReporterListener.allReported()) {
                this.forceWaitForDirScan = false;
                reportEndOfScan = false;
            } else {
                this.getFeedbackChannel().debug("Waiting for dir scanners to report.");
                return;
            }
        }
        if (this.archiveMonitor == null || this.archiveMonitor.isDone()) {
            if (this.dirScnannerReporterListener.allReported()) {
                FileSet nextFileSet = new FileSet(this.dirScnannerReporterListener.restartListening());
                this.dirScannersSchedule();
                if (!this.beforeFirstScan) {
                    if (reportEndOfScan) {
                        this.listener.endOfScan();
                    }
                    this.reportDeletions(nextFileSet);
                } else {
                    this.beforeFirstScan = false;
                }
                this.curFileSet = nextFileSet;
                this.fileSetIterator = this.curFileSet.getFileIterator();
            }
        } else {
            this.getFeedbackChannel().info("Waiting for archive monitor to finish scan.");
            return;
        }
    }

    public String toString() {
        return "FileSystemMonitor[" + this.listener.getDSInstance() + "]";
    }

    public void reset() {
        this.forceRestart();
    }

    public String getDataSourceName() {
        return FS_DATA_SOURCE_TYPE;
    }

    public FileDataSourceConfigProps getConfigurationProps() {
        return this.dataSourceConfigProps;
    }

    @Override
    public void stop() {
    }

    @Override
    public void restartScan() {
        this.forceRestart();
        this.listener.restartScan();
    }

    @Override
    public void restartCollection() {
        this.forceRestart();
        this.listener.restartCollection();
    }

    IDataSourceListener getDSListener() {
        return this.listener;
    }

    private void forceRestart() {
        if (this.archiveMonitor != null) {
            this.archiveMonitor.reset();
        }
        this.loadCacheList();
        this.fileSetIterator = EMPTY_ITER;
        this.forceWaitForDirScan = true;
    }

    private void loadCacheList() {
        this.curFileSet = new FileSet(this.getFeedbackChannel());
        for (AFileSpec fileS : this.listener.getCache().keySet()) {
            if (fileS instanceof RealFileSpec) {
                this.curFileSet.addFile(fileS);
                continue;
            }
            if (this.archiveMonitor == null) continue;
            this.archiveMonitor.loadZipEntry((ZipEntryFileSpec)fileS);
        }
        this.beforeFirstScan = this.curFileSet.size() == 0;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.listener.getFeedback();
    }

    private void dirScannersSchedule() {
        Iterator iter = this.dirScanners.iterator();
        while (iter.hasNext()) {
            ((DirectoryScanner)iter.next()).schedule();
        }
    }

    private void schedule() {
        this.dirScannersSchedule();
        if (this.archiveMonitor != null) {
            this.archiveMonitor.schedule();
        }
    }

    void reportDeletion(AFileSpec fileS) throws RestartCollectionException, RestartScanException {
        if (this.archiveMonitor != null && AFileSpecRuntime.isArchiveFile(fileS.getName()).booleanValue()) {
            this.archiveMonitor.deleteArchive(fileS);
        } else {
            this.reportDeleteEvent(fileS);
        }
    }

    private void reportDeletions(FileSet nextFileSet) throws RestartCollectionException, RestartScanException {
        Iterator iter = this.curFileSet.getFileIterator();
        while (iter.hasNext()) {
            AFileSpec fileS = (AFileSpec)iter.next();
            if (nextFileSet.contains(fileS)) continue;
            this.reportDeletion(fileS);
        }
    }

    void pollAndReportFileContent(IFileSpecRuntime fileS) throws IOException, RestartCollectionException, RestartScanException {
        if (!fileS.exists()) {
            return;
        }
        IRaveContentCache cache = this.listener.getCache();
        FileCacheEntry cachedEntry = (FileCacheEntry)cache.get(fileS.getFileSpec());
        boolean fileChanged = false;
        long fileSize = fileS.length() >= 0L ? fileS.length() : 0L;
        long lastModified = fileS.lastModified() >= 0L ? fileS.lastModified() : 0L;
        boolean newFile = false;
        byte[] digest = null;
        if (cachedEntry == null) {
            fileChanged = true;
            newFile = true;
        } else if (cachedEntry.hasDigest()) {
            if (this.dataSourceConfigProps.useDigest == 1) {
                digest = FastMD5Encoder.getInstance().encode(fileS.getFile());
                if (!FileSystemMonitor.compareDigest(digest, cachedEntry.getDigest())) {
                    fileChanged = true;
                }
            } else {
                if (fileSize != cachedEntry.getLength() || lastModified != cachedEntry.getLastModified()) {
                    fileChanged = true;
                }
                if (fileChanged && this.dataSourceConfigProps.useDigest == 0 && FileSystemMonitor.compareDigest(digest = FastMD5Encoder.getInstance().encode(fileS.getFile()), cachedEntry.getDigest())) {
                    fileChanged = false;
                }
            }
        } else if (this.dataSourceConfigProps.useDigest != 2 || fileSize != cachedEntry.getLength() || lastModified != cachedEntry.getLastModified()) {
            fileChanged = true;
        }
        if (fileChanged) {
            boolean useDigest;
            if (this.archiveMonitor != null && fileS.isArchive()) {
                this.archiveMonitor.handleArchiveFileChange(new ArchiveFileInfoHolder(fileS.getFileSpec(), fileS.getFile(), newFile, lastModified, fileSize, digest));
                return;
            }
            boolean bl = useDigest = this.dataSourceConfigProps.useDigest != 2;
            if (digest == null && useDigest) {
                digest = FastMD5Encoder.getInstance().encode(fileS.getFile());
            }
            Object fileContent = useDigest ? (this.reportContent(fileS) ? new ASCIIFileContent(this.listener.getDSInstance(), fileS.getFullName(), fileS.getFileOwner(), new FileContentValue(fileS.getContent()), lastModified, fileSize, digest) : new FileContent(this.listener.getDSInstance(), fileS.getFullName(), fileS.getFileOwner(), lastModified, fileSize, digest)) : (this.reportContent(fileS) ? new ASCIIFileContent(this.listener.getDSInstance(), fileS.getFullName(), fileS.getFileOwner(), new FileContentValue(fileS.getContent()), lastModified, fileSize) : new FileContent(this.listener.getDSInstance(), fileS.getFullName(), fileS.getFileOwner(), lastModified, fileSize));
            this.reportChangeEvent((FileContent)fileContent, fileS.getFileSpec(), newFile);
        }
    }

    void reportChangeEvent(FileContent fileContent, AFileSpec fileS, boolean newFile) throws RestartCollectionException, RestartScanException {
        IAgentContentChangeEvent contentChangeEvent = newFile ? AgentFileChangeEvent.getAdditionChangeEvent(new Date().getTime(), fileS, fileContent) : AgentFileChangeEvent.getModificationChangeEvent(new Date().getTime(), fileS, fileContent);
        this.listener.contentChangeEvent(contentChangeEvent);
    }

    void reportDeleteEvent(AFileSpec fileS) throws RestartCollectionException, RestartScanException {
        FileCacheEntry cachedEntry = (FileCacheEntry)this.listener.getCache().get(fileS);
        if (cachedEntry == null) {
            return;
        }
        IAgentContentChangeEvent contentChangeEvent = AgentFileChangeEvent.getDeletionChangeEvent(new Date().getTime(), fileS, this.listener.getDSInstance(), FileContent.class);
        this.listener.contentChangeEvent(contentChangeEvent);
    }

    boolean reportContent(IFileSpecRuntime fileS) throws IOException {
        String fileName = fileS.getName();
        return fileS.length() < (long)this.dataSourceConfigProps.maxFileSizeToUpload && !fileName.endsWith(".class") && !fileName.endsWith(".gif") && !fileName.endsWith(".jpeg") && !fileName.endsWith(".jpg") && !fileName.endsWith(".png") && !fileName.endsWith(".bmp") && !fileName.endsWith(".pdf") && !fileName.endsWith(".doc") && !fileName.endsWith(".exe") && !fileName.endsWith(".dll") && !fileName.endsWith(".cab") && !fileName.endsWith(".ocx") && !fileName.endsWith(".sys") && !fileName.endsWith(".bin") && !fileName.endsWith(".so") && !fileName.endsWith(".ico") && !fileName.endsWith(".tar") && !fileS.isArchive() && fileS.isASCII();
    }

    private static final boolean compareDigest(byte[] first, byte[] second) {
        return Arrays.equals(first, second);
    }
}

