/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.FileFactory;
import com.wily.rave.agent.ds.file.fileSpec.JavaDefaultFile;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AFileSpec
implements Externalizable {
    protected String fName;

    public AFileSpec() {
    }

    protected AFileSpec(String name) {
        if (name == null) {
            throw new IllegalArgumentException("File name must be provided!");
        }
        this.fName = name.intern();
    }

    public abstract String toString();

    public String getName() {
        return this.fName;
    }

    public abstract String getFullName();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fName = (String)in.readObject();
    }

    public String getFileOwner() {
        FileFactory factory = FileFactory.getFileFactory();
        JavaDefaultFile file = factory.getFile(this.getFullName());
        return file.getOwner();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fName);
    }
}

