/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.IFileSpecRuntime;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AFileSpecRuntime
implements IFileSpecRuntime {
    protected final AFileSpec fileS;
    private Boolean isArchive;
    private Boolean isASCII;
    private byte[] content;

    public AFileSpecRuntime(AFileSpec fileS) {
        this.fileS = fileS;
    }

    @Override
    public AFileSpec getFileSpec() {
        return this.fileS;
    }

    @Override
    public String getName() {
        return this.fileS.getName();
    }

    @Override
    public String toString() {
        return this.fileS.toString();
    }

    @Override
    public String getFullName() {
        return this.fileS.getFullName();
    }

    @Override
    public String getFileOwner() {
        return this.fileS.getFileOwner();
    }

    @Override
    public boolean isArchive() {
        if (this.isArchive == null) {
            this.isArchive = AFileSpecRuntime.isArchiveFile(this.getName());
        }
        return this.isArchive;
    }

    @Override
    public boolean isASCII() throws IOException {
        if (this.isASCII == null) {
            this.isASCII = AFileSpecRuntime.isContentASCII(this.getContent());
        }
        return this.isASCII;
    }

    @Override
    public byte[] getContent() throws IOException {
        if (this.content == null) {
            this.content = this.getFileContent();
        }
        return this.content;
    }

    protected abstract InputStream getInputStream() throws IOException;

    private byte[] getFileContent() throws IOException {
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream(1024);
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(this.getInputStream());
            byte[] buf = new byte[1024];
            int readLast = ((InputStream)inStream).read(buf);
            while (readLast != -1) {
                dataBuffer.write(buf, 0, readLast);
                readLast = ((InputStream)inStream).read(buf);
            }
            byte[] byArray = dataBuffer.toByteArray();
            return byArray;
        }
        finally {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
    }

    public static Boolean isArchiveFile(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1) {
            return Boolean.FALSE;
        }
        String extension = fileName.substring(extIndex + 1);
        return extension.equals("jar") || extension.equals("zip") || extension.equals("war") || extension.equals("ear") || extension.equals("rar") || extension.equals("sar") ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Boolean isContentASCII(byte[] content) throws IOException {
        int i = 0;
        while (i < content.length) {
            if (content[i] > 127 || content[i] < 0) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }
}

