/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpec;
import com.wily.rave.utils.TmpFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipEntryFileSpecRuntime
extends AFileSpecRuntime {
    private static final String ZIP_ENTRY_FILE_SPEC_TMP_DIR_PROP = String.valueOf(ZipEntryFileSpecRuntime.class.getName()) + ".tmpDir";
    private static final String ZIP_ENTRY_FILE_SPEC_TMP_DIR_DEF_VALUE = ".";
    private static final int BUF_SIZE = 1024;
    private static int tmpFileNameCounter = -1;
    private static File tmpDir;
    private ZipEntry entry;
    private ZipFile zipFile;
    private File tmpFile;

    static {
        String tmpDirName = System.getProperty(ZIP_ENTRY_FILE_SPEC_TMP_DIR_PROP, ZIP_ENTRY_FILE_SPEC_TMP_DIR_DEF_VALUE);
        tmpDir = new File(tmpDirName);
    }

    public ZipEntryFileSpecRuntime(ZipEntryFileSpec fSpec, ZipFile zipFile, ZipEntry entry) {
        super(fSpec);
        this.entry = entry;
        this.zipFile = zipFile;
    }

    public static void setTmpDirName(String tmpDirName) {
        tmpDir = new File(tmpDirName);
    }

    @Override
    public File getFile() throws IOException {
        if (this.tmpFile == null) {
            this.tmpFile = ZipEntryFileSpecRuntime.getEntryFile(this.entry, this.zipFile);
        }
        return this.tmpFile;
    }

    @Override
    public long length() throws IOException {
        return this.entry.getSize();
    }

    @Override
    public long lastModified() throws IOException {
        long time = this.entry.getTime();
        return time > 0L ? time : 0L;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.entry.isDirectory();
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }

    private static File getEntryFile(ZipEntry entry, ZipFile zipFile) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = ZipEntryFileSpecRuntime.getTmpFile(in);
            return file;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static synchronized File createTmpFile() throws IOException {
        if (tmpDir.exists()) {
            if (tmpFileNameCounter == -1) {
                TmpFile.deleteAllFiles((File)tmpDir);
                tmpFileNameCounter = 0;
            }
        } else if (!tmpDir.mkdir()) {
            throw new IOException("Failed creating tmp directory " + tmpDir.getAbsolutePath());
        }
        File tmpFile = File.createTempFile("tmp_", String.valueOf(new Date().getTime()) + tmpFileNameCounter, tmpDir);
        TmpFile.regTmpFile((File)tmpFile);
        tmpFileNameCounter = tmpFileNameCounter == Integer.MAX_VALUE ? 0 : tmpFileNameCounter + 1;
        return tmpFile;
    }

    private static File getTmpFile(BufferedInputStream in) throws IOException {
        File file = null;
        OutputStream out = null;
        try {
            file = ZipEntryFileSpecRuntime.createTmpFile();
            out = new BufferedOutputStream(new FileOutputStream(file), 1024);
            byte[] data = new byte[1024];
            int count = in.read(data);
            while (count > 0) {
                out.write(data, 0, count);
                count = in.read(data);
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
            }
        }
        return file;
    }
}

