/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.sysprop;

import com.wily.introscope.agent.IAgent;
import com.wily.rave.agent.config.ADataSourceConfig;
import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.IUpdatingDataSourceConfig;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.sysprop.SystemPropertyMonitor;
import com.wily.rave.agent.task.Schedule;
import com.wily.util.ExcludePattern;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SysPropDataSourceConfig
extends ADataSourceConfig
implements IUpdatingDataSourceConfig {
    private SystemPropertyMonitor fDataSource;
    protected List fExcludePatterns = new LinkedList();
    protected Element updatedXMLElement;

    @Override
    public IPolledDataSource parseConfig(Element dataSourceRoot, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws ConfigException {
        this.doParse(dataSourceRoot, feedback);
        this.fDataSource = new SystemPropertyMonitor(this.fExcludePatterns.toArray(new ExcludePattern[this.fExcludePatterns.size()]));
        return this.fDataSource;
    }

    @Override
    public Schedule getMainTaskSchedule() {
        return Schedule.getOneRunSchedule();
    }

    protected void doParse(Element dataSourceRoot, IModuleFeedbackChannel feedback) throws ConfigException {
        Element clonedElement;
        String version = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "version");
        this.updatedXMLElement = null;
        if (version == null) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (version.equals("7.1")) {
            clonedElement = (Element)dataSourceRoot.cloneNode(true);
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (!version.equals("8.0")) {
            throw new ConfigException("Unknown System Property Monitor DataSource Config Version: " + version);
        }
        Node child = dataSourceRoot.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                this.parseChild(feedback, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    private void parseChild(IModuleFeedbackChannel feedback, Element child) throws ConfigException {
        String name = child.getNodeName();
        if (name.equals("exclude")) {
            String exclude = ElementParserHelper.getRequiredAttribute(child, "pattern", false);
            ExcludePattern excludePattern = new ExcludePattern(exclude);
            this.fExcludePatterns.add(excludePattern);
            Node includeChild = child.getFirstChild();
            while (includeChild != null) {
                if (includeChild instanceof Element) {
                    if (!includeChild.getNodeName().equals("include")) {
                        throw new ConfigException("Unexpected or invalid node: " + includeChild.getNodeName());
                    }
                    String include = ElementParserHelper.getRequiredAttribute((Element)includeChild, "pattern");
                    excludePattern.addIncludePattern(include);
                } else {
                    feedback.debug("Ignoring non element node " + includeChild.getNodeName() + " / " + includeChild.getNodeType() + " / \"" + includeChild.getNodeValue() + "\"");
                }
                includeChild = includeChild.getNextSibling();
            }
        } else {
            throw new ConfigException("Unexpected or invalid node: " + name);
        }
    }

    @Override
    public String getDataSourceType() {
        return "JavaPropertiesMonitor";
    }

    @Override
    public Element getUpdatedXMLElement() {
        return this.updatedXMLElement;
    }

    @Override
    public boolean shouldExistingElementBeBackedUp() {
        return true;
    }
}

