/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.Glob;
import com.wily.util.StringUtils;

public class GlobToRegularExpression {
    public static String convertGlob(Glob glob) {
        return GlobToRegularExpression.convertGlobPattern(glob.getPattern());
    }

    public static String convertGlobPattern(String globPattern) {
        String[] globs = StringUtils.parseAndTrimList(globPattern, "*", true);
        StringBuilder patternBuffer = new StringBuilder();
        if (!globPattern.startsWith("*")) {
            patternBuffer.append("^");
        }
        int x = 0;
        while (x < globs.length) {
            patternBuffer.append(GlobToRegularExpression.escape(globs[x]));
            if (x != globs.length - 1) {
                patternBuffer.append("(.*)");
            }
            ++x;
        }
        if (!globPattern.endsWith("*")) {
            patternBuffer.append("$");
        }
        return patternBuffer.toString();
    }

    public static String escape(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(2 * sz);
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u");
                buffer.append(Integer.toHexString(ch));
            } else if (ch > '\u00ff') {
                buffer.append("\\u0");
                buffer.append(Integer.toHexString(ch));
            } else if (ch > '\u007f') {
                buffer.append("\\u00");
                buffer.append(Integer.toHexString(ch));
            } else if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00");
                            buffer.append(Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000");
                        buffer.append(Integer.toHexString(ch));
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '\'': {
                        buffer.append('\\');
                        buffer.append('\'');
                        break;
                    }
                    case '\"': {
                        buffer.append('\\');
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        buffer.append('\\');
                        break;
                    }
                    case '[': {
                        buffer.append('\\');
                        buffer.append('[');
                        break;
                    }
                    case ']': {
                        buffer.append('\\');
                        buffer.append(']');
                        break;
                    }
                    case '$': {
                        buffer.append('\\');
                        buffer.append('$');
                        break;
                    }
                    case '^': {
                        buffer.append('\\');
                        buffer.append('^');
                        break;
                    }
                    case '+': {
                        buffer.append('\\');
                        buffer.append('+');
                        break;
                    }
                    case '*': {
                        buffer.append('\\');
                        buffer.append('*');
                        break;
                    }
                    case '.': {
                        buffer.append('\\');
                        buffer.append('.');
                        break;
                    }
                    case '-': {
                        buffer.append('\\');
                        buffer.append('-');
                        break;
                    }
                    case '(': {
                        buffer.append('\\');
                        buffer.append('(');
                        break;
                    }
                    case ')': {
                        buffer.append('\\');
                        buffer.append(')');
                        break;
                    }
                    case '&': {
                        buffer.append('\\');
                        buffer.append('&');
                        break;
                    }
                    case '|': {
                        buffer.append('\\');
                        buffer.append('|');
                        break;
                    }
                    case '?': {
                        buffer.append('\\');
                        buffer.append('?');
                        break;
                    }
                    case '{': {
                        buffer.append('\\');
                        buffer.append('{');
                        break;
                    }
                    case '}': {
                        buffer.append('\\');
                        buffer.append('}');
                        break;
                    }
                    case '!': {
                        buffer.append('\\');
                        buffer.append('!');
                        break;
                    }
                    case '<': {
                        buffer.append('\\');
                        buffer.append('<');
                        break;
                    }
                    case '>': {
                        buffer.append('\\');
                        buffer.append('>');
                        break;
                    }
                    case '=': {
                        buffer.append('\\');
                        buffer.append('=');
                        break;
                    }
                    case ',': {
                        buffer.append('\\');
                        buffer.append(',');
                        break;
                    }
                    case ':': {
                        buffer.append('\\');
                        buffer.append(':');
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

