/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.util.ICloseable;
import com.wily.util.event.AListenerClosureRunnable;
import com.wily.util.event.AListenerEvent;
import com.wily.util.event.ARewindingBasket;
import com.wily.util.event.AddToCollectionRunnable;
import com.wily.util.event.IBasketableListener;
import com.wily.util.event.IListenerClosure;
import com.wily.util.event.RemoveFromCollectionRunnable;
import com.wily.util.event.RewindRunnable;
import com.wily.util.event.SingleListenerClosureRunnable;
import com.wily.util.event.SynchronousExecutor;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.EventListener;
import java.util.Vector;

public abstract class ARewindingBasketable {
    private final ARewindingBasket fBasket;
    private final Vector fListeners;

    public ARewindingBasketable(ARewindingBasket basket, Class basketableListenerClass) {
        this.fBasket = basket;
        this.fListeners = new Vector();
    }

    public abstract void doBasketableRewind(IBasketableListener var1, Executor var2);

    protected abstract Object getEggLock();

    public IModuleFeedbackChannel IBasketable_getModuleFeedback() {
        return this.getBasket().IBasket_getModuleFeedback();
    }

    public void rewind(IBasketableListener listener) {
        this.rewind(listener, this.getBasket().getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind(IBasketableListener listener, Executor executor) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        try {
            Object object = this.getEggLock();
            synchronized (object) {
                executor.execute(new SingleListenerClosureRunnable(this.getNoticeStateChangedClosure(this.getCurrentState(), null), listener));
                this.doBasketableRewind(listener, executor);
                AListenerEvent rewindCompleteEvent = this.IBasketable_allocateEvent(1007);
                executor.execute(new RewindRunnable(listener, rewindCompleteEvent));
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public void broadcastRewind() {
        IListenerClosure closure = new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ARewindingBasketable.this.rewind((IBasketableListener)listener);
            }
        };
        this.broadcastListenerClosure(closure);
    }

    public void broadcastListenerClosure(IListenerClosure closure) {
        try {
            this.getEventExecutor().execute(new AListenerClosureRunnable(closure){

                @Override
                public EventListener[] getEventListeners() {
                    return ARewindingBasketable.this.getListenerSnapshot();
                }
            });
        }
        catch (InterruptedException e) {
            this.getBasket().getModuleFeedback().debug(e);
        }
    }

    EventListener[] getListenerSnapshot() {
        return this.fListeners.toArray(new EventListener[0]);
    }

    public abstract AListenerEvent IBasketable_allocateEvent(int var1);

    public abstract Object IBasketable_getBasketableKey();

    public abstract Object IBasketable_getBasketableValue();

    public ICloseable addBroadcastListenerWithRewind(IBasketableListener listener, boolean synchronous) {
        Executor executor = synchronous ? new SynchronousExecutor() : this.getBasket().getExecutor();
        return this.addBroadcastListenerWithRewind(listener, executor);
    }

    public ICloseable IBasketable_addBroadcastListenerWithRewind(IBasketableListener listener) {
        return this.addBroadcastListenerWithRewind(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ICloseable addBroadcastListenerWithRewind(final IBasketableListener listener, Executor executor) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.rewind(listener, executor);
            this.getBasket().execute(new AddToCollectionRunnable(this.fListeners, listener));
        }
        return new ICloseable(){

            @Override
            public void close() {
                ARewindingBasketable.this.IBasketable_removeBroadcastListener(listener);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseable IBasketable_addBroadcastListener(final IBasketableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.getBasket().execute(new AddToCollectionRunnable(this.fListeners, listener));
        }
        return new ICloseable(){

            @Override
            public void close() {
                ARewindingBasketable.this.IBasketable_removeBroadcastListener(listener);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IBasketable_removeBroadcastListener(IBasketableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.doRemoveBroadcastListener(listener);
        }
    }

    protected void doRemoveBroadcastListener(EventListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        this.coreRemoveBroadcastListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coreRemoveBroadcastListener(EventListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.getBasket().execute(new RemoveFromCollectionRunnable(this.fListeners, listener));
        }
    }

    public void broadcastNoticeStateChanged(Object newState, Object oldState) {
        AListenerEvent changeEvent = this.allocateStateChangedEvent(1005, newState, oldState);
        this.fBasket.noticeBasketableStateChange(changeEvent);
        this.broadcastListenerClosure(this.getNoticeStateChangedClosure(newState, oldState));
    }

    private IListenerClosure getNoticeStateChangedClosure(Object newState, Object oldState) {
        final AListenerEvent changeEvent = this.allocateStateChangedEvent(1005, newState, oldState);
        return new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IBasketableListener)listener).noticeStateChanged(changeEvent);
            }
        };
    }

    private ARewindingBasket getBasket() {
        return this.fBasket;
    }

    protected Executor getEventExecutor() {
        return this.getBasket().getExecutor();
    }

    private final Object getCurrentState() {
        return this.doGetCurrentState();
    }

    private final AListenerEvent allocateStateChangedEvent(int id, Object newState, Object oldState) {
        return this.doAllocateStateChangedEvent(id, newState, oldState);
    }

    protected abstract Object doGetCurrentState();

    protected abstract AListenerEvent doAllocateStateChangedEvent(int var1, Object var2, Object var3);

    void noticeRemoved() {
        final AListenerEvent event = this.fBasket.allocateBasketableEvent(1003, this);
        IListenerClosure closure = new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IBasketableListener)listener).noticeBasketableDisappeared(event);
            }
        };
        this.broadcastListenerClosure(closure);
    }
}

