/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class BlockBufferedRandomAccessFile
implements DataOutput,
DataInput {
    private static final int kBufferBlocks = 64;
    private static final int kBlockSize = 1024;
    private static final int kDiskCacheSize = 65536;
    private byte[] fDiskCache;
    private int fBytesOfCachedDisk;
    private long[] fDiskCacheAsLong;
    private long fDirtyBits;
    private RandomAccessFile fFile;
    private long fPos;
    private long fCacheBasePos;
    private long fFileLength;
    private DataOutput fDataOut;
    private DataInput fDataIn;

    public BlockBufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.fFile = new RandomAccessFile(file, mode);
        this.initialize(65536);
    }

    public BlockBufferedRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this.fFile = new RandomAccessFile(name, mode);
        this.initialize(65536);
    }

    public int getBufferSize() {
        return 65536;
    }

    public final int read() throws IOException {
        if (!(this.fPos >= this.fCacheBasePos && this.fPos < this.fCacheBasePos + (long)this.fBytesOfCachedDisk || this.loadCache())) {
            return -1;
        }
        return this.fDiskCache[(int)(this.fPos++ - this.fCacheBasePos)] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int bytesRead = 0;
        do {
            if ((bytesRead += this.attemptFillFromReadCache(b, off, len)) != len) continue;
            return bytesRead;
        } while (this.loadCache());
        return -1;
    }

    public void seek(long pos) throws IOException {
        this.fPos = pos;
        if (this.fPos < this.fCacheBasePos || this.cacheAvailable() < 0L) {
            this.loadCache();
        }
    }

    public long getFilePointer() {
        return this.fPos;
    }

    public FileChannel getChannel() {
        Assertion.unimplemented();
        return null;
    }

    public FileDescriptor getFD() throws IOException {
        this.flushCache();
        return this.fFile.getFD();
    }

    public void setLength(long length) throws IOException {
        this.fFileLength = length;
        this.fFile.setLength(length);
    }

    public long length() throws IOException {
        return this.fFileLength;
    }

    /*
     * Unable to fully structure code
     */
    public void flushCache() throws IOException {
        if (this.fDirtyBits == 0L) {
            return;
        }
        flushPos = this.fCacheBasePos;
        ** GOTO lbl16
        {
            this.fDirtyBits >>>= 1;
            flushPos += 1024L;
            do {
                if ((this.fDirtyBits & 1L) == 0L) continue block0;
                flushLen = 0;
                while ((this.fDirtyBits & 1L) != 0L) {
                    this.fDirtyBits >>>= 1;
                    flushLen += 1024;
                }
                this.fFile.seek(flushPos);
                this.fFile.write(this.fDiskCache, (int)(flushPos - this.fCacheBasePos), flushLen);
lbl16:
                // 2 sources

            } while (this.fDirtyBits != 0L);
        }
    }

    public long cacheAvailable() {
        return this.fPos - this.fCacheBasePos + (long)this.fDiskCache.length;
    }

    public byte[] cachemap() {
        return this.fDiskCache;
    }

    public long[] cachemapAsLong() {
        return this.fDiskCacheAsLong;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.cacheAvailable() < 1L) {
            this.loadCache();
        }
        int cacheOffset = (int)(this.fPos - this.fCacheBasePos);
        this.fDiskCache[cacheOffset] = (byte)b;
        this.fDirtyBits |= 1L << cacheOffset / 1024;
        if (++this.fPos > this.fFileLength) {
            this.fFileLength = this.fPos;
            this.fBytesOfCachedDisk = (int)(this.fFileLength - this.fCacheBasePos);
        }
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        if (this.cacheAvailable() < (long)len) {
            this.loadCache();
        }
        if (this.cacheAvailable() >= (long)len) {
            this.copyToCache(b, offset, len);
        } else {
            int leftover = len % this.fDiskCache.length;
            this.fFile.seek(this.fPos);
            this.fFile.write(b, offset, len - leftover);
            if (leftover != 0) {
                this.copyToCache(b, offset - leftover + len, leftover);
            }
        }
        if ((this.fPos += (long)len) > this.fFileLength) {
            this.fFileLength = this.fPos;
            this.fBytesOfCachedDisk = (int)(this.fFileLength - this.fCacheBasePos);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.fDataOut.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.fDataOut.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.fDataOut.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.fDataOut.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.fDataOut.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.fDataOut.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.fDataOut.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.fDataOut.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.fDataOut.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.fDataOut.writeChars(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.fDataOut.writeUTF(str);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.fDataIn.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fDataIn.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.fDataIn.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.fDataIn.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.fDataIn.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.fDataIn.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.fDataIn.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.fDataIn.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.fDataIn.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.fDataIn.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.fDataIn.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.fDataIn.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.fDataIn.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.fDataIn.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.fDataIn.readUTF();
    }

    public void close() throws IOException {
        this.flushCache();
        this.fFile.close();
    }

    private void initialize(int cacheSize) {
        this.fDiskCache = new byte[cacheSize];
        this.fDiskCacheAsLong = ByteBuffer.wrap(this.fDiskCache).asLongBuffer().array();
        this.fDataOut = new LocalDataOutput();
        this.fDataIn = new LocalDataInput();
        try {
            this.fFileLength = this.fFile.length();
            this.loadCache();
        }
        catch (IOException iOException) {
            this.fFileLength = 0L;
        }
    }

    private int attemptFillFromReadCache(byte[] b, int off, int len) {
        if (this.fPos < this.fCacheBasePos || this.fPos >= this.fCacheBasePos + (long)this.fBytesOfCachedDisk) {
            return 0;
        }
        len = Math.min(len, this.fBytesOfCachedDisk);
        FastArrayCopy.copy(this.fDiskCache, (int)(this.fPos - this.fCacheBasePos), b, off, len);
        this.fPos += (long)len;
        return len;
    }

    private void copyToCache(byte[] b, int offset, int len) {
        int cacheOffset = (int)(this.fPos - this.fCacheBasePos);
        System.arraycopy(b, offset, this.fDiskCache, cacheOffset, len);
        int firstBlock = cacheOffset / 1024;
        int lastBlock = (cacheOffset + len) / 1024;
        this.fDirtyBits |= -1L >> 63 - lastBlock & ((1L << firstBlock) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private boolean loadCache() throws IOException {
        this.flushCache();
        this.fCacheBasePos = this.fPos / 1024L * 1024L;
        int bytesToRead = Math.min(65536, (int)(this.fFileLength - this.fPos));
        this.fBytesOfCachedDisk = this.fFile.read(this.fDiskCache, 0, bytesToRead);
        if (this.fBytesOfCachedDisk < 0) {
            this.fBytesOfCachedDisk = 0;
        }
        if (this.fBytesOfCachedDisk < 65536) {
            Arrays.fill(this.fDiskCache, this.fBytesOfCachedDisk, 65536, (byte)0);
        }
        return this.fBytesOfCachedDisk > 0;
    }

    private class LocalDataInput
    extends DataInputStream {
        public LocalDataInput() {
            super(new LocalInputStream());
        }
    }

    private class LocalDataOutput
    extends DataOutputStream {
        public LocalDataOutput() {
            super(new LocalOutputStream());
        }
    }

    private class LocalInputStream
    extends InputStream {
        private LocalInputStream() {
        }

        @Override
        public int read() throws IOException {
            return BlockBufferedRandomAccessFile.this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return BlockBufferedRandomAccessFile.this.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return BlockBufferedRandomAccessFile.this.read(b);
        }

        @Override
        public void close() throws IOException {
            Assertion.unimplemented();
        }

        @Override
        public int available() throws IOException {
            Assertion.unimplemented();
            return 0;
        }

        @Override
        public synchronized void mark(int readlimit) {
            Assertion.unimplemented();
        }

        @Override
        public boolean markSupported() {
            Assertion.unimplemented();
            return super.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            Assertion.unimplemented();
        }

        @Override
        public long skip(long n) throws IOException {
            long i = 0L;
            while (i < n) {
                BlockBufferedRandomAccessFile.this.read();
                ++i;
            }
            return n;
        }
    }

    private class LocalOutputStream
    extends OutputStream {
        private LocalOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            BlockBufferedRandomAccessFile.this.write(b);
        }

        @Override
        public void close() throws IOException {
            Assertion.unimplemented();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            BlockBufferedRandomAccessFile.this.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            BlockBufferedRandomAccessFile.this.write(b);
        }

        @Override
        public void flush() throws IOException {
            Assertion.unimplemented();
        }
    }
}

