/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class WrapperUtils {
    private static final Module BA_MODULE = new Module("BrowserAgent");

    public static URLClassLoader getJARClassLoader(ClassLoader parent, IModuleFeedbackChannel feedback) throws MalformedURLException {
        URLClassLoader urlClassLoader = null;
        if (parent != null && feedback != null) {
            String jarLocation = BTThreadLocalAdministrator.getInstance().getBAExtJarLocation();
            if (jarLocation != null) {
                URL[] urlResources;
                IResource resource;
                File jarFile = new File(jarLocation);
                if (jarFile != null && (resource = WrapperUtils.getFileResource(jarFile, feedback)) != null && (urlResources = new URL[]{resource.IResource_getURL()}) != null) {
                    urlClassLoader = new URLClassLoader(urlResources, parent);
                }
            } else {
                feedback.warn(BA_MODULE, "No JAR can be found.");
            }
        }
        if (urlClassLoader != null) {
            feedback.debug(BA_MODULE, "urlClassLoader: " + urlClassLoader);
        } else {
            feedback.warn(BA_MODULE, "Returning null ClassLoader.");
        }
        return urlClassLoader;
    }

    public static IResource getFileResource(File file, IModuleFeedbackChannel feedback) {
        String extendedFileCanonicalPath;
        ExtendedFile extendedFile;
        FileBasedResource fileResource = null;
        if (file != null && file.exists() && file.canRead() && (extendedFile = new ExtendedFile(file)) != null && (extendedFileCanonicalPath = extendedFile.safeGetCanonicalPath()) != null) {
            fileResource = new FileBasedResource(extendedFileCanonicalPath);
        }
        if (fileResource != null) {
            feedback.debug(BA_MODULE, "fileResource: " + fileResource);
        }
        return fileResource;
    }
}

