/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.DateInterval;
import com.wily.utilities.properties.Messages;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class DateIntervalSetParser {
    private static final long kMilliSecondsInHour = 3600000L;
    private static final long kMilliSecondsInDay = 86400000L;
    private static final long kMilliSecondsInWeek = 604800000L;
    private static final String kMonthKey = "m";
    private static final String kYearKey = "y";
    private static final String kWeekKey = "w";
    private static final String kDayKey = "d";
    private static final String kHourKey = "h";
    private final ArrayList fList;
    private int fIndex = 0;

    private DateIntervalSetParser() throws ParseException {
        this.fList = new ArrayList();
    }

    public DateIntervalSetParser(String startDate, String endDate, String format, String interval) throws ParseException {
        this();
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        Date start = dateformat.parse(startDate);
        Date end = dateformat.parse(endDate);
        this.fList.addAll(this.constructDateIntervals(start, end, interval));
    }

    public DateIntervalSetParser(String startDate, String endDate, String format, int startDay) throws ParseException {
        this();
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        Calendar start = Calendar.getInstance();
        start.setTime(dateformat.parse(startDate));
        Calendar end = Calendar.getInstance();
        end.setTime(dateformat.parse(endDate));
        this.fList.addAll(this.generateDateIntervalsInWeeks(start, end, startDay));
    }

    public DateIntervalSetParser(Date startDate, Date endDate, String interval) {
        this.fList = this.constructDateIntervals(startDate, endDate, interval);
    }

    public DateInterval getNext() {
        return (DateInterval)this.fList.get(this.fIndex++);
    }

    public boolean hasNext() {
        return this.fIndex < this.fList.size();
    }

    public void rewind() {
        this.fIndex = 0;
    }

    public DateInterval getDateIntervalAt(int x) {
        if (x >= this.fList.size() || x < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (DateInterval)this.fList.get(x);
    }

    public int getSize() {
        return this.fList.size();
    }

    private final ArrayList constructDateIntervals(Date startDate, Date endDate, String intervalBase) {
        ArrayList list = null;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        if (intervalBase.equals(kHourKey)) {
            list = this.generateDateIntervalsInHours(startCal, endCal);
        } else if (intervalBase.equals(kDayKey)) {
            list = this.generateDateIntervalsInDays(startCal, endCal);
        } else if (intervalBase.equals(kWeekKey)) {
            list = this.generateDateIntervalsInWeeks(startCal, endCal);
        } else if (intervalBase.equals(kMonthKey)) {
            list = this.generateDateIntervalsInMonths(startCal, endCal);
        } else {
            throw new IllegalArgumentException(Messages.getString("DateIntervalSetParser.IntervalBaseNotSupportedMsg_Log", (Object)intervalBase));
        }
        return list;
    }

    private final ArrayList generateDateIntervalsInHours(Calendar start, Calendar end) {
        ArrayList<DateInterval> list = new ArrayList<DateInterval>();
        Calendar newStart = start;
        Calendar newEnd = Calendar.getInstance();
        newEnd.setTime(newStart.getTime());
        newEnd.roll(11, 1);
        newEnd.set(14, 0);
        newEnd.set(12, 0);
        newEnd.set(13, 0);
        while (newEnd.getTime().before(end.getTime())) {
            list.add(new DateInterval(newStart.getTime(), newEnd.getTime(), kHourKey));
            newEnd.set(13, 1);
            newStart.setTime(newEnd.getTime());
            newEnd.roll(11, 1);
            newEnd.set(13, 0);
            if (!newEnd.getTime().before(newStart.getTime())) continue;
            throw new IllegalStateException(Messages.getString("DateIntervalSetParser.EndTimeError_Log", newEnd.getTime(), (Object)newStart.getTime()));
        }
        list.add(new DateInterval(newStart.getTime(), end.getTime(), kHourKey));
        return list;
    }

    private final ArrayList generateDateIntervalsInDays(Calendar start, Calendar end) {
        ArrayList<DateInterval> list = new ArrayList<DateInterval>();
        Calendar newStart = start;
        Calendar newEnd = Calendar.getInstance();
        newEnd.setTime(newStart.getTime());
        newEnd.roll(6, 1);
        newEnd.set(11, 0);
        newEnd.set(14, 0);
        newEnd.set(12, 0);
        newEnd.set(13, 0);
        while (newEnd.getTime().before(end.getTime())) {
            list.add(new DateInterval(newStart.getTime(), newEnd.getTime(), kDayKey));
            newEnd.set(13, 1);
            newStart.setTime(newEnd.getTime());
            newEnd.roll(6, 1);
            if (newEnd.get(6) == 1) {
                newEnd.roll(1, 1);
            }
            newEnd.set(10, 1);
            newEnd.roll(10, -1);
            newEnd.set(13, 0);
            if (!newEnd.getTime().before(newStart.getTime())) continue;
            throw new IllegalStateException(Messages.getString("DateIntervalSetParser.EndTimeError_Log", newEnd.getTime(), (Object)newStart.getTime()));
        }
        list.add(new DateInterval(newStart.getTime(), end.getTime(), kDayKey));
        return list;
    }

    private final ArrayList generateDateIntervalsInWeeks(Calendar start, Calendar end) {
        return this.generateDateIntervalsInWeeks(start, end, 1);
    }

    private final ArrayList generateDateIntervalsInWeeks(Calendar start, Calendar end, int beginDay) {
        ArrayList<DateInterval> list = new ArrayList<DateInterval>();
        Calendar newStart = start;
        Calendar newEnd = Calendar.getInstance();
        newEnd.setTime(newStart.getTime());
        newEnd.roll(3, 1);
        newEnd.get(7);
        newEnd.set(7, beginDay);
        newEnd.set(11, 0);
        newEnd.set(14, 0);
        newEnd.set(12, 0);
        newEnd.set(13, 0);
        while (newEnd.getTime().before(end.getTime())) {
            list.add(new DateInterval(newStart.getTime(), newEnd.getTime(), kWeekKey));
            newEnd.set(13, 1);
            newStart.setTime(newEnd.getTime());
            if (newEnd.get(3) > 51) {
                Calendar tempEnd = Calendar.getInstance();
                tempEnd.setTime(newEnd.getTime());
                tempEnd.roll(3, 1);
                if (tempEnd.get(3) <= 52) {
                    newEnd.roll(1, 1);
                }
            }
            newEnd.roll(3, 1);
            if (newEnd.get(7) != beginDay) {
                newEnd.set(7, beginDay);
            }
            newEnd.set(13, 0);
            if (!newEnd.getTime().before(newStart.getTime())) continue;
            throw new IllegalStateException(Messages.getString("DateIntervalSetParser.EndTimeError_Log", newEnd.getTime(), (Object)newStart.getTime()));
        }
        list.add(new DateInterval(newStart.getTime(), end.getTime(), kWeekKey));
        return list;
    }

    private final ArrayList generateDateIntervalsInMonths(Calendar start, Calendar end) {
        ArrayList<DateInterval> list = new ArrayList<DateInterval>();
        Calendar newStart = start;
        Calendar newEnd = Calendar.getInstance();
        newEnd.setTime(newStart.getTime());
        newEnd.roll(2, 1);
        newEnd.set(5, 1);
        newEnd.set(11, 0);
        newEnd.set(14, 0);
        newEnd.set(12, 0);
        newEnd.set(13, 0);
        while (newEnd.getTime().before(end.getTime())) {
            list.add(new DateInterval(newStart.getTime(), newEnd.getTime(), kMonthKey));
            newEnd.set(13, 1);
            newStart.setTime(newEnd.getTime());
            if (newEnd.get(2) == 11) {
                newEnd.roll(1, 1);
            }
            newEnd.roll(2, 1);
            newEnd.set(13, 0);
            if (!newEnd.getTime().before(newStart.getTime())) continue;
            throw new IllegalStateException(Messages.getString("DateIntervalSetParser.EndTimeError_Log", newEnd.getTime(), (Object)newStart.getTime()));
        }
        list.add(new DateInterval(newStart.getTime(), end.getTime(), kMonthKey));
        return list;
    }

    public static final Date getHistoricalDateBasedOnPeriod(int count, String period) {
        if (count < 1) {
            throw new IllegalArgumentException(Messages.getString("DateIntervalSetParser.IllegalCountValueMsg_Log", (Object)Integer.toString(count)));
        }
        period = period.intern();
        Calendar cal = Calendar.getInstance();
        long mill = cal.getTime().getTime();
        if (period.equalsIgnoreCase(kYearKey)) {
            int negcount = -1 * count;
            cal.roll(1, negcount);
        } else if (period.equalsIgnoreCase(kMonthKey)) {
            int x = 0;
            while (x < count) {
                cal.roll(2, -1);
                if (cal.get(2) == 11) {
                    cal.roll(1, -1);
                }
                ++x;
            }
        } else if (period.equalsIgnoreCase(kWeekKey)) {
            cal.setTime(new Date(mill -= (long)count * 604800000L));
        } else if (period.equalsIgnoreCase(kDayKey)) {
            cal.setTime(new Date(mill -= (long)count * 86400000L));
        } else if (period.equalsIgnoreCase(kHourKey)) {
            cal.setTime(new Date(mill -= (long)count * 3600000L));
        } else {
            throw new IllegalArgumentException(Messages.getString("DateIntervalSetParser.UnknownCalendarPeriodError_Log", (Object)period));
        }
        return cal.getTime();
    }

    public static final int convertToCalendarWeekDay(String day) {
        if (day != null) {
            if (day.equalsIgnoreCase("saturday")) {
                return 7;
            }
            if (day.equalsIgnoreCase("sunday")) {
                return 1;
            }
            if (day.equalsIgnoreCase("monday")) {
                return 2;
            }
            if (day.equalsIgnoreCase("tuesday")) {
                return 3;
            }
            if (day.equalsIgnoreCase("wednesday")) {
                return 4;
            }
            if (day.equalsIgnoreCase("thursday")) {
                return 5;
            }
            if (day.equalsIgnoreCase("friday")) {
                return 6;
            }
        }
        return -1;
    }
}

