/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class ExceptionParser {
    private String fEntireString;
    private String[] fParsedStackTrace;
    private String fException;
    private String fMessage;

    public ExceptionParser(Throwable ex) {
        this.initialize();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        ex.printStackTrace(out);
        this.fEntireString = new String(bout.toByteArray());
        try {
            this.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExceptionParser(String stackTrace) {
        this.initialize();
        this.fEntireString = stackTrace;
        try {
            this.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        this.fParsedStackTrace = new String[0];
        this.fException = "";
        this.fMessage = "";
    }

    private void parse() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.fEntireString.getBytes());
        BufferedReader dataIn = new BufferedReader(new InputStreamReader(in));
        String nextLine = dataIn.readLine();
        if (nextLine == null) {
            return;
        }
        int index = nextLine.indexOf(58);
        if (index >= 0) {
            this.fException = nextLine.substring(0, index);
            this.fMessage = nextLine.substring(index + 1);
        } else {
            this.fException = nextLine;
            this.fMessage = "";
        }
        Vector<String> stack = new Vector<String>();
        while ((nextLine = dataIn.readLine()) != null) {
            if ((nextLine = nextLine.trim()).length() <= 3) continue;
            nextLine = nextLine.substring(3);
            stack.addElement(nextLine);
        }
        this.fParsedStackTrace = new String[stack.size()];
        stack.copyInto(this.fParsedStackTrace);
    }

    public String getExceptionClass() {
        return this.fException;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String[] getParsedStackTrace() {
        return this.fParsedStackTrace;
    }

    public String getStackTrace() {
        return this.fEntireString;
    }

    public static void main(String[] args) {
        new ExceptionParser(new NullPointerException());
    }
}

