/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.Queue;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class LimitingQueue
extends Queue {
    public static final String kLimitingQueueLogDrops = "com.wily.util.adt.LimitingQueue.log.drops";
    private boolean fHasLimit = false;
    private int fLimit = 0;
    private int fDropCount = 0;
    private boolean fLogDropsEnabled = false;
    private int fLogDropsInterval;
    private String fLogDropsMessage;
    private static final int kDefaultLogDropInterval = 250;

    public LimitingQueue(String name, IModuleFeedbackChannel feedback) {
        super(name, feedback);
    }

    public synchronized void setLimit(int newLimit) {
        if (newLimit == 0) {
            this.fHasLimit = false;
            this.fLimit = 0;
        } else {
            this.fHasLimit = true;
            this.fLimit = newLimit;
        }
    }

    @Override
    public synchronized boolean enqueue(Object data) {
        boolean result = false;
        if (this.fHasLimit) {
            if (this.size() >= this.fLimit) {
                ++this.fDropCount;
                if (this.fLogDropsEnabled) {
                    this.logDrop();
                }
                result = false;
            } else {
                result = super.enqueue(data);
            }
        } else {
            result = super.enqueue(data);
        }
        return result;
    }

    @Override
    public synchronized void setDebuggingFeature(String whichFeature, String logMessage, Object parameter) {
        try {
            if (whichFeature.equals(kLimitingQueueLogDrops)) {
                this.setLogDrops(logMessage, parameter);
            } else {
                super.setDebuggingFeature(whichFeature, logMessage, parameter);
            }
        }
        catch (Throwable throwable) {}
    }

    private synchronized void setLogDrops(String message, Object parameter) {
        int dropInterval = (Integer)parameter;
        this.fLogDropsEnabled = true;
        this.fLogDropsMessage = message == null ? "drop total: " : message;
        this.fLogDropsInterval = dropInterval == 0 ? 250 : dropInterval;
        this.getModuleFeedback().info(String.valueOf(this.getName()) + " configured " + this.fLogDropsMessage + " to " + this.fLogDropsInterval);
    }

    private void logDrop() {
        int currentDropCount = this.fDropCount;
        if (currentDropCount % this.fLogDropsInterval == 0) {
            this.getModuleFeedback().info(String.valueOf(this.getName()) + " " + this.fLogDropsMessage + " " + currentDropCount);
        }
    }
}

