/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.soaextension.tibcobw.FrontendCacheManager;

public class TibcoMBBSUtil {
    public static void addFrontendEntry(String crossThreadID, InvocationData invocationdata) {
        ITransactionElement lastFrontendCursor;
        FrontendCacheManager frontendCacheManager = FrontendCacheManager.getInstance();
        if (!frontendCacheManager.isFrontendAvailable(crossThreadID) && (lastFrontendCursor = TibcoMBBSUtil.getLastFrontendCursor(invocationdata)) != null) {
            frontendCacheManager.addFrontend(crossThreadID, lastFrontendCursor);
        }
    }

    public static void removeFrontendEntry(String crossThreadID) {
        FrontendCacheManager.getInstance().removeFrontend(crossThreadID);
    }

    public static ITransactionElement getFrontend(String correlationID) {
        return FrontendCacheManager.getInstance().getFrontend(correlationID);
    }

    public static void updateFrontend(String prevCorID, String newCorID) {
        FrontendCacheManager frontendCacheManager = FrontendCacheManager.getInstance();
        if (newCorID != null && newCorID.trim().length() != 0 && prevCorID != null && prevCorID.trim().length() != 0) {
            ITransactionElement frontend2 = frontendCacheManager.getFrontend(newCorID);
            if (frontend2 == null) {
                ITransactionElement frontend1 = frontendCacheManager.getFrontend(prevCorID);
                if (frontend1 != null) {
                    frontendCacheManager.addFrontend(newCorID, frontend1);
                }
            } else {
                frontendCacheManager.addFrontend(newCorID, frontend2);
            }
            if (!prevCorID.equals(newCorID)) {
                frontendCacheManager.removeFrontend(prevCorID);
            }
        }
    }

    public static ITransactionElement getLastFrontendCursor(InvocationData invocationData) {
        if (invocationData.getLastFrontendCursor() != null) {
            return invocationData.getLastFrontendCursor();
        }
        IStackElement previous = VirtualStack.peek();
        while (previous != null) {
            if (previous.getLastFrontendCursor() != null) {
                return previous.getLastFrontendCursor();
            }
            previous = previous.getParent();
        }
        return null;
    }
}

