/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.CorrelationTracer;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.soaextension.tibcobw.multithread.blame.MultiThreadBoundaryCollector;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class JobCreatorCorrelationTracer
extends CorrelationTracer
implements KConstants {
    public JobCreatorCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getF_Job_M(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.info("Exception in getProcessContextMap :" + e.toString());
        }
        return ctxMap;
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getF_Job_M(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.info("Exception in setProcessContextMap :" + e.toString());
        }
    }

    private Object getWorkFlow(Object job) {
        Object workflow = null;
        try {
            workflow = TibcoReflectionCache.getKM_Job_getWorkflow(job).invoke(job, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            TibcoBWUtils.getLogger().error("JobCreatorCorrelationTracer::getWorkFlow:Could Not retrieve the workflow");
        }
        return workflow;
    }

    private String getWorkFlowName(Object workflow) {
        String name = null;
        try {
            name = (String)TibcoReflectionCache.getM_Workflow_getName(workflow).invoke(workflow, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            TibcoBWUtils.getLogger().error("JobCreatorCorrelationTracer::getWorkFlowName:Could Not retrieve the workFlowName");
        }
        return name;
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
        Object processContext = invocationdata.getInvocationObject();
        boolean debug = this.fLogger.isDebugEnabled();
        try {
            Object correlationData = new Object();
            HashMap<String, Object> ctxMap = null;
            if (processContext != null) {
                ctxMap = this.getProcessContextMap(processContext);
            }
            if (ctxMap == null) {
                ctxMap = new HashMap<String, Object>();
            }
            if (!ctxMap.containsKey("CorID")) {
                new CorrelationId();
                SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
                cache.markNextCrossProcessCallAsNonBlocking();
                correlationData = TibcoBWUtils.isSerializationEnabled() ? cache.getOutgoingSerializableInstance() : new ThreadCorrelationId().getOutgoingStringFromInstance();
                if (correlationData != null) {
                    if (debug) {
                        this.fLogger.debug("JobCreatorCorrelationTracer::ITracer_finishTrace Inserting Correlation Id " + correlationData);
                    }
                    ctxMap.put("CorID", correlationData);
                    if (TibcoBWUtils.isMBBSEnabled()) {
                        MultiBoundaryBlameStackFeature blamestackfeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
                        String corId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                        if (blamestackfeature != null && !blamestackfeature.isFrontendAvailable(corId)) {
                            if (debug) {
                                this.fLogger.debug("JobCreatorCorrelationTracer:: Adding frontend: " + blamestackfeature.getFrontendComponent() + " for id:");
                                StringBuilder stringBuilder = new StringBuilder("JobCreatorCorrelationTracer:: Collector size: ");
                                blamestackfeature.getCollector();
                                this.fLogger.debug(stringBuilder.append(MultiThreadBoundaryCollector.getCollector().size()).toString());
                            }
                            blamestackfeature.enable(corId);
                        }
                    }
                    this.setProcessContextMap(processContext, ctxMap);
                }
            }
        }
        catch (Throwable exception) {
            this.fLogger.error("JobCreatorCorrelationTracer:ITracer_finishTrace : Unexpected Error." + exception.toString());
        }
        super.ITracer_finishTrace(i, invocationdata);
    }
}

