/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.soaextension.tibcobw.BWObfuscationHelper;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.ClientCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class SOAPClientCorrrelationTracer
extends ClientCorrelationTracer {
    private static final String C_ExpandedName = "com.tibco.xml.data.primitive.ExpandedName";
    private static final String C_XmlElementHelper = "com.tibco.xml.soap.helpers.XmlElementHelper";
    private static final String C_XmlCursor = "com.tibco.xml.data.cursor.XmlCursor";
    private static final String C_SoapMessage = "com.tibco.xml.soap.api.SoapMessage";
    private static final String C_ContextUtils = "com.tibco.spin.utils.ContextUtils";
    private static Class clazzExpandedName = null;
    private static Class clazzXmlElementHelper = null;
    private static Class clazzXmlCursor = null;
    private static Class clazzSoapMessage = null;
    private static Class clazzContextUtil = null;
    private static Object CorIDAttribute = null;
    private static Object expandedname = null;

    public SOAPClientCorrrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void printSOAPMessage(Object soapMessage, InvocationData data, Class clazzSoapMessage, String comment) {
        try {
            Object soapMessageAsString = null;
            ClassLoader loader = data.getInvocationObject().getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer) {
                clazzContextUtil = Class.forName(C_ContextUtils, false, loader);
            } else if (clazzContextUtil == null) {
                clazzContextUtil = Class.forName(C_ContextUtils, false, loader);
            }
            soapMessageAsString = TibcoBWUtils.invokeMethodOnClass(clazzContextUtil, KConstants.kM_ContextUtils_getSoapMessageAsString, new Class[]{clazzSoapMessage}, new Object[]{soapMessage});
            this.fLogger.debug("printSOAPMessage ::" + comment + "Outbound SoapMessage :" + soapMessageAsString);
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("printSOAPMessage :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("printSOAPMessage :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("printSOAPMessage :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("printSOAPMessage :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean debug = false;
        if (!TibcoBWUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        Object soapMessage = null;
        Object msgContext = null;
        List soapHeaders = null;
        try {
            ClassLoader loader = data.getInvocationObject().getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer) {
                clazzExpandedName = Class.forName(C_ExpandedName, false, loader);
            } else if (clazzExpandedName == null) {
                clazzExpandedName = Class.forName(C_ExpandedName, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                clazzXmlElementHelper = Class.forName(C_XmlElementHelper, false, loader);
            } else if (clazzXmlElementHelper == null) {
                clazzXmlElementHelper = Class.forName(C_XmlElementHelper, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                clazzXmlCursor = Class.forName(C_XmlCursor, false, loader);
            } else if (clazzXmlCursor == null) {
                clazzXmlCursor = Class.forName(C_XmlCursor, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                clazzSoapMessage = Class.forName(C_SoapMessage, false, loader);
            } else if (clazzSoapMessage == null) {
                clazzSoapMessage = Class.forName(C_SoapMessage, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                CorIDAttribute = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class}, new Object[]{"CorID"});
            } else if (CorIDAttribute == null) {
                CorIDAttribute = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class}, new Object[]{"CorID"});
            }
            msgContext = data.getInvocationParameterAsObject(0);
            soapMessage = TibcoReflectionCache.getM_MessageContext_getSoapMessage(msgContext);
            if (BWObfuscationHelper.isContainer) {
                expandedname = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class, String.class}, new Object[]{"http://www.ca.com/apm", "WSCorIDSOAPHeader"});
            } else if (expandedname == null) {
                expandedname = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class, String.class}, new Object[]{"http://www.ca.com/apm", "WSCorIDSOAPHeader"});
            }
            Method M_SoapMessage = TibcoReflectionCache.getM_SoapMessage_getSoapHeaderBlocks(soapMessage);
            Object soapHeadersObj = M_SoapMessage.invoke(soapMessage, KConstants.EMPTY_OBJECT_ARRAY);
            if (soapHeadersObj != null) {
                soapHeaders = (List)soapHeadersObj;
            }
            Object corIdHeaderElement = TibcoBWUtils.invokeMethodOnClass(clazzXmlElementHelper, KConstants.kM_XmlElementHelper_createXmlElement);
            Object xmlcursor = TibcoReflectionCache.getM_XinXmlElement_getXmlCursor(corIdHeaderElement);
            Object[] objectArray = new Object[3];
            objectArray[0] = expandedname;
            objectArray[1] = "WSCorIDSOAPHeader";
            TibcoReflectionCache.getM_XmlCursor_createElement(xmlcursor, new Class[]{clazzExpandedName, String.class, clazzXmlCursor}, objectArray);
            SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
            cache.markNextCrossProcessCallAsNonBlocking();
            TibcoReflectionCache.getM_XmlCursor_setAttributeStringValue(xmlcursor, new Class[]{clazzExpandedName, String.class}, new Object[]{CorIDAttribute, new CorrelationId().getOutgoingCorrelationIdStrippedForHeader()});
            debug = this.fLogger.isDebugEnabled();
            if (debug) {
                this.printSOAPMessage(soapMessage, data, clazzSoapMessage, "Before Inserting the SOAP Header");
            }
            soapHeaders.add(corIdHeaderElement);
            if (debug) {
                this.printSOAPMessage(soapMessage, data, clazzSoapMessage, "After Inserting the SOAP Header");
            }
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("SOAPClientCorrrelationTracer :: InvocationTargetException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        if (TibcoBWUtils.correlationSOAPInsertionEnabled()) {
            super.ITracer_finishTrace(index, data);
        }
    }
}

