/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.hawk.ExecInfoMonitor;
import com.wily.soaextension.tibcobw.hawk.MemoryUsageMonitor;
import com.wily.soaextension.tibcobw.hawk.ProcessDefsMonitor;
import com.wily.soaextension.tibcobw.hawk.ProcessesMonitor;
import com.wily.soaextension.tibcobw.hawk.ServiceInfosMonitor;
import com.wily.soaextension.tibcobw.hawk.StatusMonitor;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Map;

public class HawkService
implements IAgentService {
    public IRegisteredBehavior serviceInfosBehavior;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map map) {
        try {
            TibcoBWUtils.refreshLogLevels();
            if (TibcoBWUtils.isHawkMonitorEnabled()) {
                TibcoBWUtils.getLogger().debug("HawkService.IAgentService_startService");
                int frequency = agent.IAgent_getIndexedProperties().getIntProperty("com.wily.soaextension.tibcobw.hawkmonitor.frequency", 30000);
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.execinfo")) {
                    ExecInfoMonitor execInfoMonitor = ExecInfoMonitor.getInstance(agent);
                    execInfoMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)execInfoMonitor, "Hawk ExecInfo Monitor", true, (long)frequency, false);
                }
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.memoryusage")) {
                    MemoryUsageMonitor memoryUsageMonitor = MemoryUsageMonitor.getInstance(agent);
                    memoryUsageMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)memoryUsageMonitor, "Hawk MemoryUsage Monitor", true, (long)frequency, false);
                }
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.processdefs")) {
                    ProcessDefsMonitor processDefsMonitor = ProcessDefsMonitor.getInstance(agent);
                    processDefsMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)processDefsMonitor, "Hawk ProcessDefs Monitor", true, (long)frequency, false);
                }
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.status")) {
                    StatusMonitor statusMonitor = StatusMonitor.getInstance(agent);
                    statusMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)statusMonitor, "Hawk Status Monitor", true, (long)frequency, false);
                }
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.serviceinfos")) {
                    ServiceInfosMonitor serviceInfosMonitor = ServiceInfosMonitor.getInstance(agent);
                    serviceInfosMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)serviceInfosMonitor, "Hawk ServiceInfos Monitor", true, (long)frequency, false);
                }
                if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.serviceinfos")) {
                    ProcessesMonitor processesMonitor = ProcessesMonitor.getInstance(agent);
                    processesMonitor.init();
                    agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)processesMonitor, "Hawk Processes Monitor", true, (long)frequency, false);
                }
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(agent, "ERROR_IN_HAWKSERVICE", bomb);
        }
    }
}

