/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.hawk.ExecInfoMonitor;
import com.wily.soaextension.tibcobw.hawk.MemoryUsageMonitor;
import com.wily.soaextension.tibcobw.hawk.ProcessDefsMonitor;
import com.wily.soaextension.tibcobw.hawk.ProcessesMonitor;
import com.wily.soaextension.tibcobw.hawk.ServiceInfosMonitor;
import com.wily.soaextension.tibcobw.hawk.StatusMonitor;
import com.wily.util.properties.AttributeListing;

public class TibcoHawkTracer
extends ASingleInstanceTracerFactory {
    private ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public TibcoHawkTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            if (TibcoBWUtils.isHawkMonitorEnabled()) {
                Object microAgent = data.getInvocationObject();
                if (microAgent != null) {
                    String className = microAgent.getClass().getSimpleName();
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.execinfo") && className.contains("GetExecInfoMethod")) {
                        ExecInfoMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.memoryusage") && className.contains("GetMemoryUsageMethod")) {
                        MemoryUsageMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.processdefs") && className.contains("GetProcessDefsMethod")) {
                        ProcessDefsMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.status") && className.contains("GetStatusMethod")) {
                        StatusMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.activities") && className.contains("GetActivitiesMethod")) {
                        ProcessDefsMonitor.getInstance(this.getAgent()).registerActivitiesMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.serviceinfos") && className.contains("GetServiceInfosHAWKMethod")) {
                        ServiceInfosMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                    if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.serviceinfos") && className.contains("GetProcessesMethod")) {
                        ProcessesMonitor.getInstance(this.getAgent()).registerMethodObject(microAgent);
                    }
                } else {
                    TibcoBWUtils.getLogger().info("TibcoHawkTracer.ITracer_finishTrace: Invocation Object is NULL.");
                }
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_HAWKTRACER", bomb);
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        TibcoBWUtils.refreshLogLevels();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

