/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.jobstatistics.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoWeakHashSet;
import com.wily.soaextension.tibcobw.jobstatistics.tracer.JobWatchCollector;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class TibcoJobPoolMonitor
implements ITimestampedRunnable {
    private final IAgent agent;
    private JobWatchCollector collector;

    public TibcoJobPoolMonitor(IAgent agent) {
        this.agent = agent;
        this.collector = JobWatchCollector.getInstance();
    }

    public void ITimestampedRunnable_execute(long arg0) {
        HashMap tempMap = new HashMap();
        TibcoWeakHashSet ObjjobPools = this.collector.getJobPools();
        tempMap = ObjjobPools.addAll(tempMap);
        if (tempMap != null) {
            for (Object jobPool : tempMap.keySet()) {
                Object pathnameObj = tempMap.get(jobPool);
                String jobPoolName = pathnameObj != null ? (String)pathnameObj : "UnknownJobPool";
                if (jobPool == null) continue;
                try {
                    this.reportRunningJobCount(jobPool, jobPoolName);
                    this.reportThreadCount(jobPool, jobPoolName);
                    this.reportErrorCount(jobPool, jobPoolName);
                    this.reportActiveJobCount(jobPool, jobPoolName);
                }
                catch (Exception e) {
                    this.agent.IAgent_getModuleFeedback().error((Throwable)e);
                }
            }
        }
    }

    private void reportActiveJobCount(Object jobPool, String jobPoolName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String state = this.reportState(jobPool, jobPoolName);
        if (state.equalsIgnoreCase("Active")) {
            int activeJobs = this.getIntValue(KConstants.kM_JobPool_getActiveJobCount, jobPool);
            this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobPoolName + ":Active Jobs in Jobpool").ILongCounterDataAccumulator_setValue((long)activeJobs);
        }
    }

    private void reportErrorCount(Object jobPool, String jobPoolName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String state = this.reportState(jobPool, jobPoolName);
        if (state.equalsIgnoreCase("Active")) {
            long errorCount = this.getLongValue(KConstants.kM_JobPool_getErrorCount, jobPool);
            this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobPoolName + ":Job Error Count in Jobpool").ILongCounterDataAccumulator_setValue(errorCount);
        }
    }

    private void reportThreadCount(Object jobPool, String jobPoolName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String state = this.reportState(jobPool, jobPoolName);
        if (state.equalsIgnoreCase("Active")) {
            int threadCount = this.getIntValue(KConstants.kM_JobPool_getThreadCount, jobPool);
            this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobPoolName + ":Thread Count").ILongCounterDataAccumulator_setValue((long)threadCount);
        }
    }

    private void reportRunningJobCount(Object jobPool, String jobPoolName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String state = this.reportState(jobPool, jobPoolName);
        if (state.equalsIgnoreCase("Active")) {
            int runningJobCount = this.getIntValue(KConstants.kM_JobPool_getRunningJobCount, jobPool);
            this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobPoolName + ":Running Jobs in Jobpool").ILongCounterDataAccumulator_setValue((long)runningJobCount);
        }
    }

    private int getIntValue(String method, Object jobPool) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method invocationMethod = jobPool.getClass().getDeclaredMethod(method, new Class[0]);
        Integer result = (Integer)invocationMethod.invoke(jobPool, new Object[0]);
        return result;
    }

    private long getLongValue(String method, Object jobPool) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method invocationMethod = jobPool.getClass().getDeclaredMethod(method, new Class[0]);
        Long result = (Long)invocationMethod.invoke(jobPool, new Object[0]);
        return result;
    }

    private String reportState(Object jobPool, String jobPoolName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getStateMethod = jobPool.getClass().getMethod("getState", new Class[0]);
        Integer state = (Integer)getStateMethod.invoke(jobPool, new Object[0]);
        String stateName = null;
        switch (state) {
            case 0: {
                stateName = "Suspended";
                break;
            }
            case 1: {
                stateName = "Active";
                break;
            }
            case 2: {
                stateName = "Standby";
                break;
            }
            case 3: {
                stateName = "Stopping";
                break;
            }
            default: {
                stateName = "unknown";
            }
        }
        return stateName;
    }
}

