/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.multithread.blame;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiThreadBoundaryCollector {
    private static final MultiThreadBoundaryCollector INSTANCE = new MultiThreadBoundaryCollector();
    private ConcurrentHashMap<String, FrontEndCacheObject> fFrontEndCache = new ConcurrentHashMap();
    private int fErrCount = 0;

    private MultiThreadBoundaryCollector() {
    }

    public static MultiThreadBoundaryCollector getCollector() {
        return INSTANCE;
    }

    public boolean isFrontendAvailable(String correlationID) {
        boolean result = false;
        if (this.fFrontEndCache.containsKey(correlationID)) {
            return true;
        }
        return result;
    }

    public void addFrontend(String ID, String frontendComponent) {
        if (ID != null) {
            if (!this.fFrontEndCache.containsKey(ID)) {
                FrontEndCacheObject cacheObjprev = null;
                cacheObjprev = this.fFrontEndCache.putIfAbsent(ID, new FrontEndCacheObject(frontendComponent));
                if (cacheObjprev != null) {
                    this.fFrontEndCache.get(ID).incrementProcessCount();
                }
            } else {
                this.fFrontEndCache.get(ID).incrementProcessCount();
            }
        }
    }

    public void removeFrontend(String ID) {
        if (ID != null && this.fFrontEndCache.containsKey(ID)) {
            FrontEndCacheObject cacheObjprev = this.fFrontEndCache.get(ID);
            try {
                if (cacheObjprev.decrementProcessCount() == 0) {
                    this.fFrontEndCache.remove(ID);
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getFrontend(String ID) {
        if (ID != null && this.fFrontEndCache.containsKey(ID)) {
            FrontEndCacheObject cacheObjprev = this.fFrontEndCache.get(ID);
            try {
                if (cacheObjprev != null) {
                    return cacheObjprev.getFrondEnd();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public int getFrontendErrorCount() {
        return this.fErrCount;
    }

    public void noteFrontendError() {
        ++this.fErrCount;
    }

    public int size() {
        return this.fFrontEndCache.size();
    }

    private class FrontEndCacheObject {
        String fFrondEnd;
        AtomicInteger fProcessCount = new AtomicInteger(0);

        public FrontEndCacheObject(String frondEnd) {
            this.fFrondEnd = frondEnd;
            this.fProcessCount.incrementAndGet();
        }

        public void incrementProcessCount() {
            this.fProcessCount.incrementAndGet();
        }

        public int decrementProcessCount() {
            return this.fProcessCount.decrementAndGet();
        }

        public String getFrondEnd() {
            return this.fFrondEnd;
        }

        public void setFrondEnd(String frondEnd) {
            this.fFrondEnd = frondEnd;
        }
    }
}

