/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.multithread.blame.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoMBBSUtil;
import com.wily.util.properties.AttributeListing;

public class CalledBackendTracer
extends BackendTracer
implements KConstants {
    public CalledBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnStartTrace(key, tracerIndex, dataElement, parent);
        IBlameTransactionElement previous = this.getFrontend((IBlameTransactionElement)result);
        if (previous != null) {
            this.createCalledMetrics(tracerIndex, data, result, previous);
        }
        return result;
    }

    public IBlameTransactionElement getFrontend(IBlameTransactionElement result) {
        if (TibcoBWUtils.isMBBSEnabled() && TibcoBWUtils.isTibcoEngineThread()) {
            IBlameTransactionElement cursor = result;
            while (cursor != null) {
                if (cursor.isFrontend()) {
                    return cursor.getStartTraceBlamePoint();
                }
                if ((cursor = cursor.getPreviousBlamePoint()) == null || !cursor.isFrontend()) continue;
                return cursor.getStartTraceBlamePoint();
            }
            String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            return (IBlameTransactionElement)TibcoMBBSUtil.getFrontend(correlationId);
        }
        return BackendTracer.getFrontendElementForCalledBackendMetrics((IBlameTransactionElement)result);
    }

    protected Object getBlameKey(InvocationData data) {
        String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        if (correlationId == null || correlationId.trim().length() == 0) {
            ITransactionElement frontend = TibcoMBBSUtil.getFrontend(correlationId);
            ABlameComponent key = ABlameComponent.getInstance((Object)this.getComponentName(data), (Object)((WilyTransactionElement)frontend).getComponentName());
            return key;
        }
        return data.getComponentName();
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        super.updateCustomMetricsIfAny(start, data);
        boolean isPosteval = data.getProbeInformation().getProbeIdentification().getProbeMethodName().equalsIgnoreCase("postEval");
        if (data.hasInvocationThrownException() && TibcoBWUtils.isMBBSEnabled() && TibcoBWUtils.isTibcoEngineThread() && isPosteval) {
            ErrorFeature.incrementErrorMetric((WilyTransactionElement)start, (IStackElement)data);
            String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            ITransactionElement frontend = TibcoMBBSUtil.getFrontend(correlationId);
            if (frontend != null) {
                ErrorFeature.incrementErrorMetric((WilyTransactionElement)((WilyTransactionElement)frontend), (IStackElement)data);
            }
        }
    }
}

