/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoPPException;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.processes.tracer.JobThreadlocal;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class JobCourierTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private static final String TracerName = "JobCourierTracer: ";

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            variablesMap = (HashMap)TibcoReflectionCache.getF_Job_M(createdJobObject).get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
        return variablesMap;
    }

    private void setJobHashMap(Object createdJobObject, HashMap variablesMap) throws TibcoPPException {
        try {
            TibcoReflectionCache.getF_Job_M(createdJobObject).set(createdJobObject, variablesMap);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
    }

    public JobCourierTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            String param = this.getParameter("showRunningMetric");
            if (!data.isParameterCallbackInitialized()) {
                data.setParameterCallback((IInvocationDataParameterCallback)this);
            }
            boolean showRunningMetric = false;
            if (param != null) {
                showRunningMetric = Boolean.parseBoolean(param);
            }
            if (showRunningMetric) {
                super.ITracer_startTrace(tracerIndex, data);
            } else {
                String component = this.getComponentName(data);
                data.setComponentNameAt(component, tracerIndex);
                this.addComponentToBlameStack(component, data);
            }
            this.doStartTrace(tracerIndex, data);
        }
        catch (TibcoPPException tibcoPPException) {}
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String component = data.getComponentNameAt(tracerIndex);
        this.doFinishBlamePointTrace(tracerIndex, data, component);
        try {
            if (JobThreadlocal.isEnd()) {
                this.doFinishTrace(tracerIndex, data, component);
                JobThreadlocal.removeEndTh();
            }
        }
        catch (TibcoPPException e) {
            TibcoBWUtils.handleError(this.getAgent(), TracerName, e);
        }
    }

    protected void doStartTrace(int tracerIndex, InvocationData data) throws TibcoPPException {
        String component = data.getComponentNameAt(tracerIndex);
        Object createdJobObject = data.getInvocationParameterAsObject(0);
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        HashMap<String, String> variablesMap = this.getJobHashMap(createdJobObject);
        if (variablesMap == null) {
            variablesMap = new HashMap<String, String>();
        }
        if (!variablesMap.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey")) {
            variablesMap.put("com.wily.soaextension.tibcobw.BPstarttimeKey", String.valueOf(System.currentTimeMillis()));
            this.setJobHashMap(createdJobObject, variablesMap);
            IIntegerFluctuatingCounterDataAccumulator tcicounter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + ":Concurrent Invocations");
            tcicounter.IIntegerFluctuatingCounterDataAccumulator_increment();
        }
        data.put("Context_M", variablesMap);
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("JobCourierTracer: :doStartTrace:" + component);
        }
    }

    protected void doFinishTrace(int tracerIndex, InvocationData data, String component) throws TibcoPPException {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("JobCourierTracer: :doFinishTrace:" + component);
        }
        Object createdJobObject = data.getInvocationParameterAsObject(0);
        HashMap variablesMap = null;
        variablesMap = this.getCtx(data, createdJobObject);
        if (variablesMap != null && variablesMap.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey")) {
            IIntegerFluctuatingCounterDataAccumulator ciCounter;
            String st = (String)variablesMap.get("com.wily.soaextension.tibcobw.BPstarttimeKey");
            long start = Long.valueOf(st);
            long elapsed_time = System.currentTimeMillis() - start;
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("JobCourierTracer: time" + component + elapsed_time);
            }
            ILongAverageDataAccumulator timerAccumulator = this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(String.valueOf(component) + ":Average Response Time (ms)");
            timerAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(elapsed_time);
            ILongIntervalCounterDataAccumulator accumIntervalCnt = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + ":Responses Per Interval");
            if (!accumIntervalCnt.IDataAccumulator_isShutOff()) {
                accumIntervalCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            if ((ciCounter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + ":Concurrent Invocations")) != null) {
                ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
        }
    }

    protected void doFinishBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (data.hasInvocationThrownException()) {
            Throwable error = null;
            String errorMessage = null;
            error = data.getInvocationThrownException();
            errorMessage = String.valueOf(component) + ":" + error.getMessage();
            String name = String.valueOf(component) + ":" + "Errors Per Interval";
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            }
            this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(name.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("JobCourierTracer: :doFinishBlamePointTrace:" + component);
        }
        String param = this.getParameter("showRunningMetric");
        boolean showRunningMetric = false;
        if (param != null) {
            showRunningMetric = Boolean.parseBoolean(param);
        }
        if (showRunningMetric) {
            super.doFinishBlamePointTrace(tracerIndex, data, component);
        } else {
            this.removeComponentFromBlameStack(component, data);
        }
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        String businessProcessName = (String)data.get("com.wily.soaextension.tibcobw.ProcessNameKey");
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("JobCourierTracer: ProcessName for SOA TT Filter = " + businessProcessName);
        }
        if (businessProcessName != null && businessProcessName.length() > 0) {
            params.put("businessprocess", businessProcessName);
        }
    }

    public HashMap getCtx(InvocationData data, Object createdJobObject) {
        HashMap variablesMap = null;
        Object variablesMapobj = data.get("Context_M");
        try {
            variablesMap = variablesMapobj == null ? this.getJobHashMap(createdJobObject) : (HashMap)variablesMapobj;
        }
        catch (Exception exception) {}
        return variablesMap;
    }
}

