/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.tibcobw.ATibcoSingleInstanceTracer;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoPPException;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.processes.tracer.JobThreadlocal;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Field;
import java.util.HashMap;

public class JobRemoveTracer
extends ATibcoSingleInstanceTracer {
    private static final String kmtdname_getCurrentTrack = "getCurrentTrack";
    private static final String kmdname_getFullTaskName = "getFullTaskName";
    private static final String kErrorMsg = ":Process Killed";
    private static final String kpath_subprocstart = "Tibco|Processes|Subprocesses|";
    private static final String ksuprocess_startchar = ">";
    private static Field jobVariablesField = null;
    private static final String TracerName = "JobRemoveTracer: ";

    public JobRemoveTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
    }

    @Override
    public void ITracer_startTrace(int arg0, InvocationData data) {
        if (!JobThreadlocal.isEnd()) {
            JobThreadlocal.setEnd(true);
        } else {
            try {
                this.CallJobFinish(data);
            }
            catch (TibcoPPException tibcoPPException) {}
            JobThreadlocal.removeEndTh();
        }
    }

    private void CallJobFinish(InvocationData data) throws TibcoPPException {
        Object objJob = data.getInvocationParameterAsObject(0);
        String component = this.formatParameterizedName(data);
        HashMap variablesMap = null;
        try {
            variablesMap = this.getJobHashMap(objJob);
            if (variablesMap != null && variablesMap.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey")) {
                Object ObjfulltaskName;
                Object Track = TibcoReflectionCache.getM_getCurrentTrack(objJob);
                if (Track != null && (ObjfulltaskName = TibcoReflectionCache.getM_getFullTaskName(Track)) != null) {
                    String taskName = (String)ObjfulltaskName;
                    while (taskName.contains(ksuprocess_startchar)) {
                        String subcompname = kpath_subprocstart;
                        int startindex = taskName.lastIndexOf(62);
                        int lastindex = taskName.lastIndexOf(47);
                        String tempProcname = taskName.substring(startindex + 1, lastindex);
                        taskName = taskName.substring(0, startindex);
                        Object substarttime = variablesMap.get(subcompname = String.valueOf(subcompname) + tempProcname);
                        if (substarttime != null) {
                            // empty if block
                        }
                        this.recordMetrics(subcompname, (String)substarttime);
                    }
                }
                String st = (String)variablesMap.get("com.wily.soaextension.tibcobw.BPstarttimeKey");
                this.recordMetrics(component, st);
            }
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
    }

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            if (jobVariablesField == null) {
                jobVariablesField = createdJobObject.getClass().getDeclaredField(KConstants.kF_Job_M);
                jobVariablesField.setAccessible(true);
            }
            variablesMap = (HashMap)jobVariablesField.get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
        return variablesMap;
    }

    private void recordMetrics(String component, String st) {
        String errorMessage;
        IIntegerFluctuatingCounterDataAccumulator ciCounter;
        long start = Long.valueOf(st);
        long elapsed_time = System.currentTimeMillis() - start;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        ILongAverageDataAccumulator timerAccumulator = this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(String.valueOf(component) + ":Average Response Time (ms)");
        timerAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(elapsed_time);
        ILongIntervalCounterDataAccumulator accumIntervalCnt = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + ":Responses Per Interval");
        if (!accumIntervalCnt.IDataAccumulator_isShutOff()) {
            accumIntervalCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
        if ((ciCounter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + ":Concurrent Invocations")) != null) {
            ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
        }
        if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)(errorMessage = String.valueOf(component) + kErrorMsg))) {
            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug(TracerName + errorMessage);
            }
        }
        try {
            String Metricname = String.valueOf(component) + ":" + "Errors Per Interval";
            if (Metricname != null) {
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(Metricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
        catch (ESEException e) {
            Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
        }
    }
}

